/*
 * Decompiled with CFR 0.152.
 */
package net.nekin.bukkit.plugin.labyrinth;

import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.util.logging.Logger;
import net.nekin.bukkit.plugin.labyrinth.InvalidBoundsException;
import net.nekin.bukkit.plugin.labyrinth.Labyrinth;
import net.nekin.bukkit.plugin.labyrinth.LocalPlayerListener;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class LabyrinthPlugin
extends JavaPlugin {
    public static final String MSG_INVALIDARGUMENT = ChatColor.RED + "Invalid argument!";
    public static final String MSG_INVALIDHEIGHT = ChatColor.RED + "Invalid height! Height must be between 2 and 5";
    public static final String MSG_PUNCH1 = ChatColor.GREEN + "Punch a block to set the first corner of your labyrinth.";
    public static final String MSG_PUNCH2 = ChatColor.GREEN + "Now punch a block to set the second corner!";
    public static final String MSG_PUNCHENTRY = ChatColor.GREEN + "Punch the labyrinth where you want to have an entry!";
    public static final String MSG_ENTRYSUCCESSFULL = ChatColor.DARK_GREEN + "Entry to labyrinth set successfull!";
    public static final String MSG_INVALIDENTRYPOSITION = ChatColor.RED + "Invalid position for entry! There is no path behind.";
    public static final String MSG_INVALIDBOUNDS = ChatColor.RED + "Invalid bounds! Width and length must be even.";
    public static final String MSG_CONSTRUCTING = ChatColor.DARK_GREEN + "Constructing labyrinth... Step back!";
    public static final String MSG_BUILTSUCCESSFULL = ChatColor.DARK_GREEN + "Labyrinth constructed successfully!";
    public static final String MSG_BOTHPOINTSNEEDED = ChatColor.RED + "Set both bounding points first!";
    public static final String MSG_LABYRINTHEXISTS = ChatColor.RED + "Labyrinth already constructed!";
    public static final String MSG_LABYRINTHNOTEXISTS = ChatColor.RED + "Construct labyrinth first!";
    public static final String MSG_ROLLBACKSUCCESSFULL = ChatColor.DARK_GREEN + "Labyrinth successfully rolled back!";
    public static final String MSG_ROLLBACKIMPOSSIBLE = ChatColor.RED + "No labyrinth constructed to rollback!";
    public static final String MSG_NOPERMISSION = ChatColor.RED + "No permission!";
    public static final String MSG_SET1 = ChatColor.DARK_GREEN + "First position for labyrinth set at ";
    public static final String MSG_SET2 = ChatColor.DARK_GREEN + "Second position for labyrinth set at ";
    private static final String PERMISSION_ALL = "labyrinth.*";
    private final LocalPlayerListener playerListener = new LocalPlayerListener(this);
    PermissionHandler permissionHandler;
    Location p1;
    Location p2;
    Labyrinth labyrinth;
    Player commander;
    boolean waitForPunchP1 = false;
    boolean waitForPunchP2 = false;
    boolean waitForPunchEntry = false;
    static Logger log = Logger.getLogger("Minecraft");

    public void onDisable() {
    }

    public void onEnable() {
        log.info("Load Labyrinth v0.1 maintained by _skyler_");
        this.setupPermissions();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)this.playerListener, Event.Priority.Lowest, (Plugin)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.commander = (Player)sender;
        if (!this.checkPermission(this.commander, PERMISSION_ALL)) {
            this.commander.sendMessage(MSG_NOPERMISSION);
            return true;
        }
        if (label.equals("labybounds")) {
            this.waitForPunchP1 = false;
            this.waitForPunchP2 = false;
            this.labyrinth = null;
            this.commander.sendMessage(MSG_PUNCH1);
            this.waitForPunchP1 = true;
            return true;
        }
        if (label.equals("labyconstruct")) {
            int height = 2;
            if (args.length == 1) {
                String arg = args[0];
                try {
                    height = Integer.parseInt(arg);
                    if (height < 2 || height > 5) {
                        this.commander.sendMessage(MSG_INVALIDHEIGHT);
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    this.commander.sendMessage(MSG_INVALIDARGUMENT);
                    return false;
                }
            }
            if (this.labyrinth == null) {
                if (this.p1 != null && this.p2 != null) {
                    try {
                        this.commander.sendMessage(MSG_CONSTRUCTING);
                        this.labyrinth = Labyrinth.create(this.p1, this.p2, height);
                        this.labyrinth.construct();
                        this.commander.sendMessage(MSG_BUILTSUCCESSFULL);
                    }
                    catch (InvalidBoundsException e) {
                        this.commander.sendMessage(MSG_INVALIDBOUNDS);
                        this.labyrinth = null;
                    }
                } else {
                    this.commander.sendMessage(MSG_BOTHPOINTSNEEDED);
                }
            } else {
                this.commander.sendMessage(MSG_LABYRINTHEXISTS);
            }
            return true;
        }
        if (label.equals("labyrollback")) {
            if (this.labyrinth != null) {
                this.labyrinth.rollbackTerrain();
                this.labyrinth = null;
                this.commander.sendMessage(MSG_ROLLBACKSUCCESSFULL);
            } else {
                this.commander.sendMessage(MSG_ROLLBACKIMPOSSIBLE);
            }
            return true;
        }
        if (label.equals("labyentry")) {
            if (this.labyrinth != null) {
                this.waitForPunchEntry = true;
                this.commander.sendMessage(MSG_PUNCHENTRY);
            } else {
                this.commander.sendMessage(MSG_LABYRINTHNOTEXISTS);
            }
            return true;
        }
        return false;
    }

    private void setupPermissions() {
        Plugin permissionsPlugin = this.getServer().getPluginManager().getPlugin("Permissions");
        if (this.permissionHandler == null && permissionsPlugin != null) {
            this.permissionHandler = ((Permissions)permissionsPlugin).getHandler();
        }
    }

    public boolean checkPermission(Player p, String ... perms) {
        if (this.permissionHandler == null) {
            if (p.isOp()) {
                return true;
            }
        } else {
            if (this.permissionHandler.has(p, PERMISSION_ALL)) {
                return true;
            }
            String[] stringArray = perms;
            int n = perms.length;
            int n2 = 0;
            while (n2 < n) {
                String perm = stringArray[n2];
                if (this.permissionHandler.has(p, perm)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

