/*
 * Decompiled with CFR 0.152.
 */
package net.nekin.bukkit.plugin.labyrinth;

import java.awt.Point;
import java.util.HashMap;
import java.util.Random;
import net.nekin.bukkit.plugin.labyrinth.InvalidBoundsException;
import net.nekin.bukkit.plugin.labyrinth.PositionType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class Labyrinth {
    World world;
    Random ran = new Random();
    HashMap<Block, Material> previousTerrain = new HashMap();
    int offsetX;
    int offsetY;
    int offsetZ;
    int p1x;
    int p1z;
    int p2x;
    int p2z;
    int y;
    int width;
    int length;
    int height;
    PositionType[][] l;
    Point entry;

    public static Labyrinth create(Location p1, Location p2, int height) throws InvalidBoundsException {
        if (p1 == null || p2 == null || height <= 1) {
            throw new InvalidBoundsException();
        }
        Labyrinth labyrinth = new Labyrinth();
        labyrinth.p1x = p1.getBlockX();
        labyrinth.p1z = p1.getBlockZ();
        labyrinth.p2x = p2.getBlockX();
        labyrinth.p2z = p2.getBlockZ();
        labyrinth.y = p1.getBlockY();
        labyrinth.height = height;
        labyrinth.world = p1.getWorld();
        if (!Labyrinth.isValid(labyrinth.p1x, labyrinth.p1z, labyrinth.p2x, labyrinth.p2z)) {
            throw new InvalidBoundsException();
        }
        labyrinth.length = Math.abs(labyrinth.p1x - labyrinth.p2x) + 1;
        labyrinth.width = Math.abs(labyrinth.p1z - labyrinth.p2z) + 1;
        labyrinth.normalizePoints();
        labyrinth.l = new PositionType[labyrinth.length][labyrinth.width];
        labyrinth.offsetX = labyrinth.p1x;
        labyrinth.offsetY = labyrinth.y;
        labyrinth.offsetZ = labyrinth.p1z;
        labyrinth.init();
        labyrinth.step(1, 1, 1, 0, (byte)0);
        labyrinth.fillWalls();
        return labyrinth;
    }

    public static boolean isValid(int x1, int z1, int x2, int z2) {
        return x1 != x2 && z1 != z2 && Math.abs(x1 - x2) >= 4 && Math.abs(z1 - z2) >= 4 && (Math.abs(x1 - x2) + 1) % 2 == 0 && (Math.abs(z1 - z2) + 1) % 2 == 0;
    }

    private void normalizePoints() {
        int temp;
        if (this.p2x < this.p1x) {
            temp = this.p1x;
            this.p1x = this.p2x;
            this.p2x = temp;
        }
        if (this.p2z < this.p1z) {
            temp = this.p1z;
            this.p1z = this.p2z;
            this.p2z = temp;
        }
    }

    public void init() {
        int i = 0;
        while (i < this.length) {
            int j = 0;
            while (j < this.width) {
                this.l[i][j] = i == 0 || i == this.length - 1 || j == 0 || j == this.width - 1 ? PositionType.BORDER : PositionType.EMTPY;
                ++j;
            }
            ++i;
        }
    }

    public void print() {
        System.out.println(this.toString());
    }

    public boolean step(int x, int z, int mx, int mz, byte triedDir) {
        boolean NONE = false;
        boolean STRAIGHT = true;
        int MINUS = 2;
        int STRAIGHT_MINUS = 3;
        int PLUS = 4;
        int STRAIGHT_PLUS = 5;
        int MINUS_PLUS = 6;
        int STRAIGHT_MINUS_PLUS = 7;
        int nextDir = 0;
        switch (triedDir) {
            case 7: {
                return false;
            }
            case 0: {
                int r = this.ran.nextInt(3);
                if (r == 0) {
                    nextDir = 2;
                    break;
                }
                if (r == 1) {
                    nextDir = 4;
                    break;
                }
                if (r != 2) break;
                nextDir = 1;
                break;
            }
            case 2: {
                int r = this.ran.nextInt(2);
                if (r == 0) {
                    nextDir = 4;
                    break;
                }
                if (r != 1) break;
                nextDir = 1;
                break;
            }
            case 4: {
                int r = this.ran.nextInt(2);
                if (r == 0) {
                    nextDir = 2;
                    break;
                }
                if (r != 1) break;
                nextDir = 1;
                break;
            }
            case 1: {
                int r = this.ran.nextInt(2);
                if (r == 0) {
                    nextDir = 4;
                    break;
                }
                if (r != 1) break;
                nextDir = 2;
                break;
            }
            case 6: {
                nextDir = 1;
                break;
            }
            case 3: {
                nextDir = 4;
                break;
            }
            case 5: {
                nextDir = 2;
            }
        }
        triedDir = (byte)(triedDir | nextDir);
        int tx = mx;
        int tz = mz;
        switch (nextDir) {
            case 4: {
                tx = Math.abs(mz);
                tz = Math.abs(mx);
                break;
            }
            case 2: {
                tx = Math.abs(mz) * -1;
                tz = Math.abs(mx) * -1;
                break;
            }
        }
        this.l[x][z] = PositionType.PATH;
        if (this.isNextPositionEmpty(x, z, tx, tz) && this.areNeighborsOk(x, z, tx, tz)) {
            this.step(x + tx, z + tz, tx, tz, (byte)0);
        }
        return this.step(x, z, mx, mz, triedDir);
    }

    private boolean areNeighborsOk(int x, int z, int mx, int mz) {
        PositionType n = this.l[x + mx + Math.abs(mz)][z + mz + Math.abs(mx)];
        return n != PositionType.PATH && (n = this.l[x + mx - Math.abs(mz)][z + mz - Math.abs(mx)]) != PositionType.PATH;
    }

    private boolean isBreakthrough(int x, int z, int mx, int mz) {
        if (x + Math.abs(mx) * 2 < 0 || x + Math.abs(mx) * 2 >= this.length - 1 || z + Math.abs(mz) * 2 < 0 || z + Math.abs(mz) * 2 >= this.width - 1) {
            return true;
        }
        PositionType n = this.l[x + Math.abs(mx) * 2][z + Math.abs(mz) * 2];
        return n == PositionType.PATH;
    }

    private boolean isPositionEmpty(int x, int z) {
        return this.isNextPositionEmpty(x, z, 0, 0);
    }

    private boolean isNextPositionEmpty(int x, int z, int mx, int mz) {
        return this.l[x + mx][z + mz].equals((Object)PositionType.EMTPY);
    }

    public void construct() {
        int x = 0;
        while (x < this.length) {
            int z = 0;
            while (z < this.width) {
                int y = 0;
                while (y < this.height + 2) {
                    PositionType p = this.l[x][z];
                    Material m = p.material();
                    Block b = this.world.getBlockAt(x + this.offsetX, y + this.offsetY, z + this.offsetZ);
                    this.previousTerrain.put(b, b.getType());
                    if (y == 0) {
                        b.setType(Material.MOSSY_COBBLESTONE);
                    } else if (y == this.height + 1) {
                        b.setType(Material.GLASS);
                    } else if (y == 2 && p == PositionType.PATH && x % 3 == 0 && z % 3 == 0) {
                        b.setType(Material.TORCH);
                    } else {
                        b.setType(m);
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
    }

    public void rollbackTerrain() {
        int x = 0;
        while (x < this.length) {
            int z = 0;
            while (z < this.width) {
                int y = 0;
                while (y < this.height + 2) {
                    Block b = this.world.getBlockAt(x + this.offsetX, y + this.offsetY, z + this.offsetZ);
                    b.setType(this.previousTerrain.get(b));
                    ++y;
                }
                ++z;
            }
            ++x;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder(String.valueOf(this.getClass().toString()) + "\n");
        s.append("length: " + this.length + "\n");
        s.append("width: " + this.width + "\n");
        s.append("height: " + this.height + "\n");
        s.append("p1x: " + this.p1x + "\n");
        s.append("p1z: " + this.p1z + "\n");
        s.append("p2x: " + this.p2x + "\n");
        s.append("p2z: " + this.p2z + "\n");
        s.append("y: " + this.y + "\n");
        s.append("offsetX: " + this.offsetX + "\n");
        s.append("offsetY: " + this.offsetY + "\n");
        s.append("offsetZ: " + this.offsetZ + "\n");
        String line = "";
        int i = 0;
        while (i < this.width) {
            int j = 0;
            while (j < this.length) {
                String c = new String("" + this.l[j][i].i());
                if (c.equals("0")) {
                    c = " ";
                }
                s.append(c);
                ++j;
            }
            s.append("\n");
            ++i;
        }
        return s.toString();
    }

    private void fillWalls() {
        int x = 0;
        while (x < this.length) {
            int z = 0;
            while (z < this.width) {
                if (this.l[x][z] == PositionType.EMTPY) {
                    this.l[x][z] = PositionType.WALL;
                }
                ++z;
            }
            ++x;
        }
    }

    private void setEntriesInWorld() {
        int x = 0;
        while (x < this.length) {
            int z = 0;
            while (z < this.width) {
                int y = 1;
                while (y <= 2) {
                    PositionType p = this.l[x][z];
                    Material m = p.material();
                    Block b = this.world.getBlockAt(x + this.offsetX, y + this.offsetY, z + this.offsetZ);
                    if (p == PositionType.ENTRY) {
                        b.setType(p.material());
                    }
                    ++y;
                }
                z += this.width - 1;
            }
            ++x;
        }
    }

    public boolean setEntry(int x, int z) {
        x -= this.offsetX;
        z -= this.offsetZ;
        try {
            if (this.l[x][z] == PositionType.BORDER) {
                if (x == this.p1x && z > this.p1z && z < this.p2z) {
                    if (this.l[x + 1][z] == PositionType.PATH) {
                        this.l[x][z] = PositionType.ENTRY;
                    }
                } else if (z == this.p1z && x > this.p1x && x < this.p2x) {
                    if (this.l[x][z + 1] == PositionType.PATH) {
                        this.l[x][z] = PositionType.ENTRY;
                    }
                } else if (x == this.p2x && z > this.p1z && z < this.p2z) {
                    if (this.l[x - 1][z] == PositionType.PATH) {
                        this.l[x][z] = PositionType.ENTRY;
                    }
                } else if (z == this.p2z && x > this.p1x && x < this.p2x && this.l[x][z - 1] == PositionType.PATH) {
                    this.l[x][z] = PositionType.ENTRY;
                }
                this.setEntriesInWorld();
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }
}

