/*
 * Decompiled with CFR 0.152.
 */
package com.carneiro.mcredsim;

import com.carneiro.mcredsim.Blocks;
import com.carneiro.mcredsim.Field;
import com.carneiro.mcredsim.Tag;
import com.carneiro.mcredsim.Viewport;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class LevelLoader {
    public static void load(Viewport p, String world, int cX, int cY) {
        LevelLoader.load(p, "C:\\Users\\Mario\\AppData\\Roaming\\.minecraft\\saves\\" + world + "\\" + Integer.toString(cX & 0x3F, 36) + "\\" + Integer.toString(cY & 0x3F, 36) + "\\c." + Integer.toString(cX, 36) + "." + Integer.toString(cY, 36) + ".dat");
    }

    public static void load(Viewport p, String file) {
        byte[] data = null;
        byte[] extra = null;
        int sX = 16;
        int sY = 16;
        int sZ = 128;
        boolean sch = file.endsWith(".schematic");
        try {
            Tag root = Tag.readFrom(new FileInputStream(file));
            data = (byte[])root.findTagByName("Blocks").getValue();
            extra = (byte[])root.findTagByName("Data").getValue();
            if (sch) {
                sX = ((Short)root.findTagByName("Width").getValue()).shortValue();
                sY = ((Short)root.findTagByName("Length").getValue()).shortValue();
                sZ = ((Short)root.findTagByName("Height").getValue()).shortValue();
            }
        }
        catch (Exception root) {
            // empty catch block
        }
        byte[][][] chunk = new byte[sZ][][];
        byte[][][] cext = new byte[sZ][][];
        int i = 0;
        while (i < sZ) {
            chunk[i] = new byte[sY][];
            cext[i] = new byte[sY][];
            int j = 0;
            while (j < sY) {
                chunk[i][j] = new byte[sX];
                cext[i][j] = new byte[sX];
                int k = 0;
                while (k < sX) {
                    byte d;
                    int n;
                    if (sch) {
                        n = i * sY * sX + j * sX + k;
                        d = (byte)(extra[n] & 0xF);
                    } else {
                        n = i + j * sZ + k * sY * sZ;
                        d = extra[n >> 1];
                        d = (i & 1) == 0 ? (byte)(d & 0xF) : (byte)((d & 0xF0) >> 4);
                    }
                    switch (data[n]) {
                        case 0: 
                        case 6: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 51: 
                        case 59: 
                        case 63: 
                        case 65: 
                        case 66: 
                        case 68: 
                        case 78: 
                        case 83: {
                            chunk[i][j][k] = (byte)Blocks.air.ordinal();
                            break;
                        }
                        case 55: {
                            cext[i][j][k] = d;
                            chunk[i][j][k] = (byte)Blocks.wire.ordinal();
                            break;
                        }
                        case 76: {
                            cext[i][j][k] = 16;
                        }
                        case 75: {
                            byte[] byArray = cext[i][j];
                            int n2 = k;
                            int[] nArray = new int[6];
                            nArray[1] = 128;
                            nArray[2] = 96;
                            nArray[3] = 64;
                            nArray[4] = 32;
                            byArray[n2] = (byte)(byArray[n2] + nArray[d]);
                            chunk[i][j][k] = (byte)Blocks.torch.ordinal();
                            break;
                        }
                        case 69: {
                            chunk[i][j][k] = (byte)Blocks.lever.ordinal();
                            if (d >= 8) {
                                d = (byte)(d - 8);
                                cext[i][j][k] = 16;
                            }
                            byte[] byArray = cext[i][j];
                            int n3 = k;
                            int[] nArray = new int[7];
                            nArray[1] = 128;
                            nArray[2] = 96;
                            nArray[3] = 64;
                            nArray[4] = 32;
                            byArray[n3] = (byte)(byArray[n3] + (byte)nArray[d]);
                            break;
                        }
                        case 70: 
                        case 72: {
                            chunk[i][j][k] = (byte)Blocks.press.ordinal();
                            int[] nArray = new int[2];
                            nArray[1] = 10;
                            cext[i][j][k] = (byte)nArray[d];
                            break;
                        }
                        case 77: {
                            chunk[i][j][k] = (byte)Blocks.button.ordinal();
                            if (d >= 8) {
                                d = (byte)(d - 8);
                                cext[i][j][k] = 16;
                            }
                            byte[] byArray = cext[i][j];
                            int n4 = k;
                            byArray[n4] = (byte)(byArray[n4] + (new int[]{32, 128, 96, 64, 32})[d]);
                            break;
                        }
                        case 64: 
                        case 71: {
                            if (d < 8) {
                                chunk[i][j][k] = (byte)Blocks.doorA.ordinal();
                                if (d >= 4) {
                                    d = (byte)(d - 4);
                                    cext[i][j][k] = 16;
                                }
                                byte[] byArray = cext[i][j];
                                int n5 = k;
                                byArray[n5] = (byte)(byArray[n5] + (new int[]{96, 64, 128, 32})[d]);
                                break;
                            }
                            chunk[i][j][k] = (byte)Blocks.doorB.ordinal();
                            cext[i][j][k] = 0;
                            break;
                        }
                        case 8: 
                        case 10: {
                            cext[i][j][k] = 16;
                        }
                        case 9: 
                        case 11: {
                            chunk[i][j][k] = (byte)Blocks.water.ordinal();
                            byte[] byArray = cext[i][j];
                            int n6 = k;
                            byArray[n6] = (byte)(byArray[n6] + d);
                        }
                        case 12: 
                        case 13: {
                            chunk[i][j][k] = (byte)Blocks.sand.ordinal();
                            break;
                        }
                        default: {
                            chunk[i][j][k] = (byte)Blocks.block.ordinal();
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        p.field.data = chunk;
        p.field.extra = cext;
        p.setSize(sX, sY, sZ);
        p.recountRed();
        p.view.repaint();
    }

    public static void save(Viewport p, String file) {
        short s = p.field.data.length;
        short s2 = p.field.data[0].length;
        short s3 = p.field.data[0][0].length;
        byte[] blocks = new byte[s3 * s2 * s];
        byte[] data = new byte[s3 * s2 * s];
        int i = 0;
        int n = 0;
        while (i < s) {
            int j = 0;
            while (j < s2) {
                int k = 0;
                while (k < s3) {
                    switch (p.field.g(k, j, i)) {
                        case air: 
                        case shadow: {
                            data[n] = 0;
                            blocks[n] = 0;
                            break;
                        }
                        case block: {
                            blocks[n] = p.block == 2 ? (byte)(p.field.g(k, j, i + 1).block() ? 3 : 2) : (byte)p.block;
                            data[n] = 0;
                            break;
                        }
                        case wire: {
                            blocks[n] = 55;
                            data[n] = p.field.extra[i][j][k];
                            break;
                        }
                        case torch: {
                            blocks[n] = (byte)(p.field.p(k, j, i) ? 76 : 75);
                            data[n] = (byte)(5 - (p.field.extra[i][j][k] >> 5 & 7));
                            break;
                        }
                        case button: {
                            blocks[n] = 77;
                            byte[] byArray = new byte[5];
                            byArray[1] = 4;
                            byArray[2] = 3;
                            byArray[3] = 2;
                            byArray[4] = 1;
                            data[n] = (byte)(byArray[p.field.extra[i][j][k] >> 5 & 7] + (p.field.p(k, j, i) ? 8 : 0));
                            break;
                        }
                        case lever: {
                            blocks[n] = 69;
                            data[n] = (byte)((new byte[]{(byte)(Field.dummyGdValve ? 6 : 5), 4, 3, 2, 1})[p.field.extra[i][j][k] >> 5 & 7] + (p.field.p(k, j, i) ? 8 : 0));
                            break;
                        }
                        case press: {
                            blocks[n] = 70;
                            data[n] = (byte)(p.field.extra[i][j][k] != 0 ? 1 : 0);
                            break;
                        }
                        case doorA: {
                            blocks[n] = 71;
                            byte[] byArray = new byte[5];
                            byArray[1] = 3;
                            byArray[2] = 1;
                            byArray[4] = 2;
                            data[n] = (byte)(byArray[p.field.extra[i][j][k] >> 5 & 7] + (p.field.p(k, j, i) ? 4 : 0));
                            break;
                        }
                        case doorB: {
                            blocks[n] = 71;
                            data[n] = (byte)(data[n - s3 * s2] + 8);
                            break;
                        }
                        case water: {
                            blocks[n] = (byte)((p.field.extra[i][j][k] & 0x10) == 0 ? 9 : 8);
                            data[n] = (byte)(p.field.extra[i][j][k] & 0xF);
                        }
                    }
                    ++k;
                    ++n;
                }
                ++j;
            }
            ++i;
        }
        try {
            new Tag(Tag.Type.TAG_Compound, "Schematic", new Tag[]{new Tag(Tag.Type.TAG_Short, "Height", s), new Tag(Tag.Type.TAG_Short, "Length", s2), new Tag(Tag.Type.TAG_Short, "Width", s3), new Tag(Tag.Type.TAG_Byte_Array, "Blocks", blocks), new Tag(Tag.Type.TAG_Byte_Array, "Data", data), new Tag(Tag.Type.TAG_String, "Materials", "Alpha"), new Tag("Entities", Tag.Type.TAG_Compound), new Tag("TileEntities", Tag.Type.TAG_Compound), new Tag(Tag.Type.TAG_End, null, null)}).writeTo(new FileOutputStream(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Viewport v = new Viewport(0, 0, 0);
        LevelLoader.load(v, "C:\\Users\\Mario\\Minecraft\\bcd.schematic");
        v.stats.revalidate();
        v.view.revalidate();
        v.frame.pack();
        LevelLoader.save(v, "C:\\Users\\Mario\\Minecraft\\bcd2.schematic");
    }
}

