/*
 * Decompiled with CFR 0.152.
 */
package com.carneiro.mcredsim;

import com.carneiro.mcredsim.Blocks;
import com.carneiro.mcredsim.Colors;
import com.carneiro.mcredsim.Palette;
import com.carneiro.mcredsim.Viewport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class Field {
    private Viewport parent;
    byte[][][] data;
    byte[][][] extra;
    int wires;
    int torches;
    public static boolean cyclic = false;
    public static boolean dummyGdValve = false;
    public static boolean MCwires = true;
    public static boolean bridge = true;
    public static int layers = 3;
    private static final int[][] dir;

    static {
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[3];
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = -1;
        nArrayArray[4] = nArray5;
        dir = nArrayArray;
    }

    public Field(Viewport v, int x, int y, int z) {
        this.parent = v;
        this.data = new byte[z][][];
        this.extra = new byte[z][][];
        this.torches = 0;
        this.wires = 0;
        int i = 0;
        while (i < z) {
            this.data[i] = new byte[y][];
            this.extra[i] = new byte[y][];
            int j = 0;
            while (j < y) {
                this.data[i][j] = new byte[x];
                this.extra[i][j] = new byte[x];
                int k = 0;
                while (k < x) {
                    this.data[i][j][k] = 0;
                    this.extra[i][j][k] = 0;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public Field(Viewport v, byte[][][] d, byte[][][] e) {
        this.parent = v;
        this.data = d;
        this.extra = e;
        this.torches = 0;
        this.wires = 0;
    }

    public Blocks g(int x, int y, int z) {
        if (z < 0) {
            return Blocks.block;
        }
        if (z >= this.data.length) {
            return Blocks.air;
        }
        if (cyclic) {
            y = (y % this.data[0].length + this.data[0].length) % this.data[0].length;
            x = (x % this.data[0][0].length + this.data[0][0].length) % this.data[0][0].length;
        } else if (y < 0 || y >= this.data[0].length || x < 0 || x >= this.data[0][0].length) {
            return Blocks.air;
        }
        return Blocks.values()[this.data[z][y][x]];
    }

    public boolean p(int x, int y, int z) {
        return this.gp(x, y, z) != 0;
    }

    public int gp(int x, int y, int z) {
        if (z < 0 || this.g(x, y, z).air()) {
            return 0;
        }
        if (cyclic) {
            y = (y % this.data[0].length + this.data[0].length) % this.data[0].length;
            x = (x % this.data[0][0].length + this.data[0][0].length) % this.data[0][0].length;
        } else if (y < 0 || y >= this.data[0].length || x < 0 || x >= this.data[0][0].length) {
            return 0;
        }
        return this.extra[z][y][x] & 0x1F;
    }

    public int w(int x, int y, int z) {
        if (z < 0 || z >= this.data.length) {
            return 0;
        }
        if (cyclic) {
            y = (y % this.data[0].length + this.data[0].length) % this.data[0].length;
            x = (x % this.data[0][0].length + this.data[0][0].length) % this.data[0][0].length;
        } else if (y < 0 || y >= this.data[0].length || x < 0 || x >= this.data[0][0].length) {
            return 0;
        }
        return this.extra[z][y][x] >> 5 & 7;
    }

    public void s(int x, int y, int z, Blocks v) {
        if (z < 0 || z >= this.data.length || this.g(x, y, z) == v) {
            return;
        }
        if (cyclic) {
            y = (y % this.data[0].length + this.data[0].length) % this.data[0].length;
            x = (x % this.data[0][0].length + this.data[0][0].length) % this.data[0][0].length;
        } else if (y < 0 || y >= this.data[0].length || x < 0 || x >= this.data[0][0].length) {
            return;
        }
        if (this.g(x, y, z) == Blocks.torch) {
            --this.torches;
        } else if (this.g(x, y, z) == Blocks.wire) {
            --this.wires;
        } else if (this.g(x, y, z).block()) {
            if (this.g(x, y, z + 1) == Blocks.wire || this.g(x, y, z + 1) == Blocks.doorA) {
                this.s(x, y, z + 1, Blocks.air);
            }
            int i = 0;
            while (i < 5) {
                if (this.g((int)(x - Field.dir[i][0]), (int)(y - Field.dir[i][1]), (int)(z - Field.dir[i][2])).wall % 2 == 1 && this.w(x - dir[i][0], y - dir[i][1], z - dir[i][2]) == i) {
                    this.s(x - dir[i][0], y - dir[i][1], z - dir[i][2], Blocks.air);
                }
                ++i;
            }
        } else if (this.g(x, y, z) == Blocks.doorA) {
            this.data[z][y][x] = (byte)v.ordinal();
            this.s(x, y, z + 1, Blocks.air);
        } else if (this.g(x, y, z) == Blocks.doorB) {
            this.data[z][y][x] = (byte)v.ordinal();
            this.s(x, y, z - 1, Blocks.air);
        }
        if (v == Blocks.torch) {
            ++this.torches;
        } else if (v == Blocks.wire) {
            ++this.wires;
        }
        this.data[z][y][x] = (byte)v.ordinal();
        this.parent.updateRed();
    }

    public boolean s(int x, int y, int z, int w) {
        if (!this.valid(x, y, z, w)) {
            return false;
        }
        this.extra[z][y][x] = (byte)((w << 5) + (this.extra[z][y][x] & 0x1F));
        return true;
    }

    public void sp(int x, int y, int z, int p) {
        if (z < 0 || z >= this.data.length) {
            return;
        }
        if (cyclic) {
            y = (y % this.data[0].length + this.data[0].length) % this.data[0].length;
            x = (x % this.data[0][0].length + this.data[0][0].length) % this.data[0][0].length;
        } else if (y < 0 || y >= this.data[0].length || x < 0 || x >= this.data[0][0].length) {
            return;
        }
        if (this.g(x, y, z) == Blocks.doorA) {
            if (this.p(x, y, z)) {
                if (p == 0) {
                    this.parent.play(false);
                }
            } else if (p != 0) {
                this.parent.play(true);
            }
            this.sp(x, y, z + 1, p);
        }
        this.extra[z][y][x] = (byte)((this.extra[z][y][x] & 0xE0) + p);
    }

    public boolean s(int x, int y, int z, Blocks b, int e) {
        if (z < 0 || z >= this.data.length) {
            return false;
        }
        if (cyclic) {
            y = (y % this.data[0].length + this.data[0].length) % this.data[0].length;
            x = (x % this.data[0][0].length + this.data[0][0].length) % this.data[0][0].length;
        } else if (y < 0 || y >= this.data[0].length || x < 0 || x >= this.data[0][0].length) {
            return false;
        }
        if (this.g(x, y, z) == b && this.extra[z][y][x] == e) {
            return false;
        }
        this.s(x, y, z, b);
        this.extra[z][y][x] = (byte)e;
        return true;
    }

    public boolean match(int x, int y, int z, Palette p) {
        return !(this.g(x, y, z) != p.a || p.b != null && this.g(x, y, z + 1) != p.b || p.c != null && this.g(x, y, z + 1) != p.c);
    }

    private boolean valid(int x, int y, int z, int w) {
        if (w == 0) {
            return this.g((int)x, (int)y, (int)z).wall < 2;
        }
        if (this.g((int)x, (int)y, (int)z).wall % 2 == 0) {
            return this.g((int)x, (int)y, (int)z).wall == 2;
        }
        return this.g(x + dir[w][0], y + dir[w][1], z + dir[w][2]).block();
    }

    public void draw(int x, int y, int z, Graphics g, Rectangle r, Blocks ... b) {
        int p = 0;
        boolean whiteout = false;
        boolean fake = b.length != 0;
        if (!fake) {
            b = new Blocks[]{this.g(x, y, z), this.g(x, y, z + 1), this.g(x, y, z + 2)};
        }
        if (b[0].block()) {
            ++p;
            if (Viewport.waterMode) {
                if (b[0] == Blocks.sand) {
                    g.setColor(Colors.sand);
                } else {
                    g.setColor(Colors.dirt);
                }
            } else {
                g.setColor(Colors.block);
            }
        } else if (b[0].air()) {
            if (b[0] == Blocks.shadow && (layers == 1 || b[1].air())) {
                g.setColor(Colors.grid);
            } else {
                ++p;
                whiteout = true;
                g.setColor(Colors.air);
            }
        } else {
            g.setColor(Colors.air);
        }
        g.fillRect(r.x, r.y, r.width, r.height);
        if (b[0] == Blocks.wire) {
            if (fake) {
                Field.drawWire(g, r, true, 15, false);
            } else {
                this.drawWire(g, r, x, y, z, false);
            }
            if (layers > 1 && !b[++p].air() && !b[p].block()) {
                g.setColor(Colors.aircover);
                g.fillRect(r.x, r.y, r.width, r.height);
            }
        }
        if (p > 0 && layers == 1) {
            return;
        }
        boolean tog = true;
        switch (b[p]) {
            case wire: {
                if (fake) {
                    Field.drawWire(g, r, true, 15, false);
                    break;
                }
                this.drawWire(g, r, x, y, z + p, false);
                break;
            }
            case lever: {
                tog = false;
            }
            case torch: {
                g.setColor(Colors.door);
                if (fake || this.w(x, y, z + p) == 1) {
                    g.fillRect(r.x + 3, r.y + 3, 2, 5);
                } else if (this.w(x, y, z + p) == 2) {
                    g.fillRect(r.x + 3, r.y, 2, 5);
                } else if (this.w(x, y, z + p) == 3) {
                    g.fillRect(r.x + 3, r.y + 3, 5, 2);
                } else if (this.w(x, y, z + p) == 4) {
                    g.fillRect(r.x, r.y + 3, 5, 2);
                }
                if (!tog) {
                    g.setColor(Colors.valve);
                } else if (fake || this.p(x, y, z + p)) {
                    g.setColor(Colors.wireOn);
                } else {
                    g.setColor(Colors.wireOff);
                }
                g.fillOval(r.x + 2, r.y + 2, 4, 4);
                g.setColor(Colors.wireOn);
                if (tog || fake || !this.p(x, y, z + p)) break;
                g.fillOval(r.x + 3, r.y + 3, 2, 2);
                break;
            }
            case button: {
                g.setColor(Colors.button);
                if (!fake && this.p(x, y, z + p)) {
                    if (this.w(x, y, z + p) == 1) {
                        g.fillRect(r.x + 2, r.y + 7, 4, 1);
                        break;
                    }
                    if (this.w(x, y, z + p) == 2) {
                        g.fillRect(r.x + 2, r.y, 4, 1);
                        break;
                    }
                    if (this.w(x, y, z + p) == 3) {
                        g.fillRect(r.x + 7, r.y + 2, 1, 4);
                        break;
                    }
                    if (this.w(x, y, z + p) != 4) break;
                    g.fillRect(r.x, r.y + 2, 1, 4);
                    break;
                }
                if (fake || this.w(x, y, z + p) == 1) {
                    g.fillRect(r.x + 2, r.y + 5, 4, 3);
                    break;
                }
                if (this.w(x, y, z + p) == 2) {
                    g.fillRect(r.x + 2, r.y, 4, 3);
                    break;
                }
                if (this.w(x, y, z + p) == 3) {
                    g.fillRect(r.x + 5, r.y + 2, 3, 4);
                    break;
                }
                if (this.w(x, y, z + p) != 4) break;
                g.fillRect(r.x, r.y + 2, 3, 4);
                break;
            }
            case press: {
                if (!fake && this.p(x, y, z + p)) {
                    g.setColor(Colors.wireOn);
                } else {
                    g.setColor(Colors.valve);
                }
                g.fillRect(r.x + 1, r.y + 1, 6, 6);
                break;
            }
            case doorB: {
                --p;
            }
            case doorA: {
                g.setColor(Colors.door);
                int w = 1;
                int c = 2;
                if (!fake) {
                    int[] nArray = new int[4];
                    nArray[0] = 2;
                    nArray[2] = 3;
                    nArray[3] = 1;
                    c = w = nArray[this.w(x, y, z + p) - 1];
                    if (this.w(x, y, z + p + 1) != 2) {
                        c = (c + 1) % 4;
                    }
                    if (this.p(x, y, z + p)) {
                        w = (w + (this.w(x, y, z + p + 1) == 2 ? 3 : 1)) % 4;
                    }
                }
                if (w == 0) {
                    g.fillRect(r.x, r.y, 8, 2);
                } else if (w == 1) {
                    g.fillRect(r.x + 6, r.y, 2, 8);
                } else if (w == 2) {
                    g.fillRect(r.x, r.y + 6, 8, 2);
                } else if (w == 3) {
                    g.fillRect(r.x, r.y, 2, 8);
                }
                if (!fake && this.p(x, y, z + p)) {
                    g.setColor(Colors.wireOn);
                } else {
                    g.setColor(Colors.wireOff);
                }
                if (c == 0) {
                    g.fillRect(r.x, r.y, 2, 2);
                    break;
                }
                if (c == 1) {
                    g.fillRect(r.x + 6, r.y, 2, 2);
                    break;
                }
                if (c == 2) {
                    g.fillRect(r.x + 6, r.y + 6, 2, 2);
                    break;
                }
                if (c != 3) break;
                g.fillRect(r.x, r.y + 6, 2, 2);
                break;
            }
            case water: {
                int col = fake ? Colors.water.getRGB() : ((~this.gp(x, y, z + p) & 7) * 24 + 87 << 24) + (Colors.water.getRGB() & 0xFFFFFF);
                g.setColor(new Color(col, true));
                g.fillRect(r.x, r.y, r.width, r.height);
                g.setColor(Color.BLACK);
                if (fake) break;
                if ((this.gp(x, y, z + p) & 8) != 0) {
                    g.fillOval(r.x + 3, r.y + 3, 2, 2);
                    break;
                }
                if ((this.gp(x, y, z + p) & 0xF) != 0) break;
                g.fillRect(r.x + 3, r.y + 3, 2, 2);
            }
        }
        if (b[1].block() && layers > 1) {
            g.setColor(Colors.cover);
            g.fillRect(r.x, r.y, r.width, r.height);
            if (layers > 2 && b[2] == Blocks.wire && (b[0] == (bridge ? Blocks.wire : Blocks.air) || b[0].block())) {
                if (fake) {
                    Field.drawWire(g, r, true, 12, false);
                } else {
                    this.drawWire(g, r, x, y, z + 2, false);
                }
            }
        } else if (whiteout) {
            g.setColor(Colors.fog);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    private boolean c(int x, int y, int x2, int y2, int z) {
        if (MCwires) {
            if (this.g(x2, y2, z).air()) {
                return this.g((int)x2, (int)y2, (int)(z - 1)).conn;
            }
            if (this.g(x2, y2, z).block()) {
                return !this.g(x, y, z + 1).block() && this.g((int)x2, (int)y2, (int)(z + 1)).conn;
            }
            return true;
        }
        if (this.g((int)x2, (int)y2, (int)z).conn) {
            return true;
        }
        if (this.g(x2, y2, z).air()) {
            return this.g(x2, y2, z - 1) == Blocks.wire;
        }
        if (this.g(x2, y2, z).block()) {
            if (this.g(x2, y2, z + 1) == Blocks.wire && !this.g(x, y, z + 1).block()) {
                return true;
            }
            int i = 0;
            while (i < 5) {
                if (this.g((int)(x2 - Field.dir[i][0]), (int)(y2 - Field.dir[i][1]), (int)(z - Field.dir[i][2])).wall % 2 == 1 && this.w(x2 - dir[i][0], y2 - dir[i][1], z - dir[i][2]) == i) {
                    if (this.g(x2 - dir[i][0], y2 - dir[i][1], z - dir[i][2]) == Blocks.torch) {
                        return this.blockConnect(x2, y2, x - x2, y - y2, z, false);
                    }
                    return i != 0 || this.g(x2, y2, z + 1) != Blocks.lever || !dummyGdValve;
                }
                ++i;
            }
            return this.g(x2, y2, z - 1) == Blocks.torch;
        }
        return false;
    }

    public void drawWire(Graphics g, Rectangle r, int x, int y, int z, boolean thick) {
        Field.drawWire(g, r, this.p(x, y, z), (this.c(x, y, x - 1, y, z) ? 8 : 0) + (this.c(x, y, x + 1, y, z) ? 4 : 0) + (this.c(x, y, x, y - 1, z) ? 2 : 0) + (this.c(x, y, x, y + 1, z) ? 1 : 0), false);
    }

    public static void drawWire(Graphics g, Rectangle r, boolean on, int c, boolean thick) {
        if (on) {
            g.setColor(Colors.wireOn);
        } else {
            g.setColor(Colors.wireOff);
        }
        if (MCwires) {
            if ((c & 3) == 0) {
                c = (c & 0xC) == 0 ? 15 : 12;
            } else if ((c & 0xC) == 0) {
                c = 3;
            }
        } else if (c == 0) {
            g.fillRect(r.x + 2, r.y + 2, 4, 4);
        }
        if ((c & 1) != 0) {
            g.fillRect(r.x + 3, r.y + 3, 2, 5);
        }
        if ((c & 2) != 0) {
            g.fillRect(r.x + 3, r.y, 2, 5);
        }
        if ((c & 4) != 0) {
            g.fillRect(r.x + 3, r.y + 3, 5, 2);
        }
        if ((c & 8) != 0) {
            g.fillRect(r.x, r.y + 3, 5, 2);
        }
    }

    public void update() {
        int x;
        int y;
        int z = 0;
        while (z < this.data.length) {
            y = 0;
            while (y < this.data[0].length) {
                x = 0;
                while (x < this.data[0][0].length) {
                    if (this.g(x, y, z) == Blocks.wire || this.g(x, y, z) == Blocks.doorB) {
                        this.sp(x, y, z, 0);
                    } else if (this.g(x, y, z).block()) {
                        this.sp(x, y, z, 0);
                        if (this.p(x, y, z - 1) && this.g(x, y, z - 1) == Blocks.torch) {
                            this.sp(x, y, z, 17);
                        } else {
                            int i = dummyGdValve ? 1 : 0;
                            while (i < 5) {
                                if (this.g(x - dir[i][0], y - dir[i][1], z - dir[i][2]).ctrl() && this.w(x - dir[i][0], y - dir[i][1], z - dir[i][2]) == i && this.p(x - dir[i][0], y - dir[i][1], z - dir[i][2])) {
                                    this.sp(x, y, z, 17);
                                }
                                ++i;
                            }
                        }
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        z = 0;
        while (z < this.data.length) {
            y = 0;
            while (y < this.data[0].length) {
                x = 0;
                while (x < this.data[0][0].length) {
                    if (this.gp(x, y, z) >= (this.g(x, y, z) == Blocks.button || this.g(x, y, z) == Blocks.press ? 1 : 16) && (this.g(x, y, z) == Blocks.torch || this.g(x, y, z).ctrl() || this.g(x, y, z).block() && this.gp(x, y, z) == 17)) {
                        if (this.g(x, y, z - 1) == Blocks.wire) {
                            this.followWire(x, y, z - 1, 15);
                        }
                        if (this.g(x, y, z + 1) == Blocks.wire) {
                            this.followWire(x, y, z + 1, 15);
                        }
                        if (this.g(x, y + 1, z) == Blocks.wire) {
                            this.followWire(x, y + 1, z, 15);
                        }
                        if (this.g(x, y - 1, z) == Blocks.wire) {
                            this.followWire(x, y - 1, z, 15);
                        }
                        if (this.g(x + 1, y, z) == Blocks.wire) {
                            this.followWire(x + 1, y, z, 15);
                        }
                        if (this.g(x - 1, y, z) == Blocks.wire) {
                            this.followWire(x - 1, y, z, 15);
                        }
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        z = 0;
        while (z < this.data.length) {
            y = 0;
            while (y < this.data[0].length) {
                x = 0;
                while (x < this.data[0][0].length) {
                    if ((this.g(x, y, z).block() && !this.p(x, y, z) || this.g(x, y, z) == Blocks.doorA) && (this.g(x, y, z + 1) == Blocks.wire && this.p(x, y, z + 1) || this.blockConnect(x, y, 0, 1, z, true) || this.blockConnect(x, y, 0, -1, z, true) || this.blockConnect(x, y, 1, 0, z, true) || this.blockConnect(x, y, -1, 0, z, true))) {
                        this.sp(x, y, z, 16);
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        z = 0;
        while (z < this.data.length) {
            y = 0;
            while (y < this.data[0].length) {
                x = 0;
                while (x < this.data[0][0].length) {
                    if (this.g(x, y, z) == Blocks.doorA && !this.p(x, y, z + 1)) {
                        if (this.powerDoor(x, y, z + 2) || this.powerDoor(x, y, z - 1) || this.powerDoor(x, y + 1, z) || this.powerDoor(x, y + 1, z + 1) || this.powerDoor(x, y - 1, z) || this.powerDoor(x, y - 1, z + 1) || this.powerDoor(x + 1, y, z) || this.powerDoor(x + 1, y, z + 1) || this.powerDoor(x - 1, y, z) || this.powerDoor(x - 1, y, z + 1)) {
                            this.sp(x, y, z, 16);
                        } else {
                            this.sp(x, y, z, 0);
                        }
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    private boolean powerDoor(int x, int y, int z) {
        return this.g(x, y, z) != Blocks.doorA && this.g(x, y, z) != Blocks.doorB && this.p(x, y, z);
    }

    private boolean blockConnect(int x, int y, int dx, int dy, int z, boolean pow) {
        if (this.g(x + dx, y + dy, z) != Blocks.wire || !this.p(x + dx, y + dy, z) && pow) {
            return false;
        }
        if (this.g(x + dx + dy, y + dy - dx, z).block()) {
            if (!this.g(x + dx, y + dy, z + 1).block() && this.g((int)(x + dx + dy), (int)(y + dy - dx), (int)(z + 1)).conn) {
                return false;
            }
        } else if (this.g(x + dx + dy, y + dy - dx, z).air()) {
            if (this.g((int)(x + dx + dy), (int)(y + dy - dx), (int)(z - 1)).conn) {
                return false;
            }
        } else {
            return false;
        }
        if (this.g(x + dx - dy, y + dy + dx, z).block()) {
            return this.g(x + dx, y + dy, z + 1).block() || !this.g((int)(x + dx - dy), (int)(y + dy + dx), (int)(z + 1)).conn;
        }
        if (this.g(x + dx - dy, y + dy + dx, z).air()) {
            return !this.g((int)(x + dx - dy), (int)(y + dy + dx), (int)(z - 1)).conn;
        }
        return false;
    }

    private void followWire(int x, int y, int z, int p) {
        if (p <= this.gp(x, y, z)) {
            return;
        }
        this.sp(x, y, z, p);
        if (p == 0) {
            return;
        }
        this.followWireQ(x, y, x, y + 1, z, p - 1);
        this.followWireQ(x, y, x, y - 1, z, p - 1);
        this.followWireQ(x, y, x + 1, y, z, p - 1);
        this.followWireQ(x, y, x - 1, y, z, p - 1);
    }

    private void followWireQ(int x, int y, int x2, int y2, int z, int p) {
        if (this.g(x2, y2, z) == Blocks.wire) {
            this.followWire(x2, y2, z, p);
        } else if (this.g(x2, y2, z).block()) {
            if (this.g(x2, y2, z + 1) == Blocks.wire && !this.g(x, y, z + 1).block()) {
                this.followWire(x2, y2, z + 1, p);
            }
        } else if (this.g(x2, y2, z - 1) == Blocks.wire) {
            this.followWire(x2, y2, z - 1, p);
        }
    }

    private int findLowGround(int x, int y, int z, int depth) {
        if (!this.g(x, y, z).destruct()) {
            return Integer.MAX_VALUE;
        }
        if (this.g(x, y, z - 1).destruct()) {
            return depth;
        }
        if (depth == 5) {
            return Integer.MAX_VALUE;
        }
        return Math.min(Math.min(this.findLowGround(x, y + 1, z, depth + 1), this.findLowGround(x, y - 1, z, depth + 1)), Math.min(this.findLowGround(x + 1, y, z, depth + 1), this.findLowGround(x - 1, y, z, depth + 1)));
    }

    public void tick() {
        int x;
        int y;
        this.parent.modify();
        int z = 0;
        while (z < this.data.length) {
            y = 0;
            while (y < this.data[0].length) {
                x = 0;
                while (x < this.data[0][0].length) {
                    if (this.g(x, y, z) == Blocks.water && (this.gp(x, y, z) & 0x10) != 0 && this.w(x, y, z) == 0) {
                        boolean mod = false;
                        if (this.g(x, y, z - 1).destruct() || this.g(x, y, z - 1) == Blocks.water && (this.gp(x, y, z - 1) & 8) == 0 && (this.gp(x, y, z - 1) & 0xF) != 0) {
                            mod |= this.s(x, y, z - 1, Blocks.water, this.gp(x, y, z) | 0x38);
                        } else if ((this.gp(x, y, z) & 0xF) != 7 && (this.g(x, y, z - 1) == Blocks.water ? (this.gp(x, y, z) & 0xF) == 0 : !this.g(x, y, z - 1).destruct())) {
                            int[] sp = new int[4];
                            int spMin = Integer.MAX_VALUE;
                            int i = 1;
                            while (i < 5) {
                                sp[i - 1] = this.findLowGround(x + dir[i][0], y + dir[i][1], z, 1);
                                if (sp[i - 1] < spMin) {
                                    spMin = sp[i - 1];
                                }
                                ++i;
                            }
                            int g = this.gp(x, y, z) & 0xF;
                            g = g >= 8 ? 1 : g + 1;
                            int i2 = 1;
                            while (i2 < 5) {
                                if (sp[i2 - 1] == spMin && (this.g(x + dir[i2][0], y + dir[i2][1], z).destruct() || this.g(x + dir[i2][0], y + dir[i2][1], z) == Blocks.water && (this.gp(x + dir[i2][0], y + dir[i2][1], z) ^ 7) > (g ^ 7))) {
                                    mod |= this.s(x + dir[i2][0], y + dir[i2][1], z, Blocks.water, g + 48);
                                }
                                ++i2;
                            }
                        }
                        if (!mod) {
                            this.s(x, y, z, Blocks.water, this.gp(x, y, z) & 0xF);
                        }
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        z = 0;
        while (z < this.data.length) {
            y = 0;
            while (y < this.data[0].length) {
                x = 0;
                while (x < this.data[0][0].length) {
                    if (this.g(x, y, z) == Blocks.water) {
                        this.s(x, y, z, 0);
                    } else if (this.g(x, y, z) == Blocks.torch) {
                        int[] w = dir[this.w(x, y, z)];
                        this.sp(x, y, z, this.gp(x + w[0], y + w[1], z + w[2]) >= 16 ? 0 : 16);
                    } else if (this.p(x, y, z) && (this.g(x, y, z) == Blocks.button || this.g(x, y, z) == Blocks.press && (this.parent.lastX != x || this.parent.lastY != y || z != this.parent.lyr && z != this.parent.lyr + 1))) {
                        this.sp(x, y, z, this.gp(x, y, z) - 1);
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        this.update();
    }

    public void save(File f) throws FileNotFoundException, IOException {
        int j;
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(f));
        dos.writeInt(1382376531);
        dos.writeByte(1);
        dos.writeShort(this.parent.z);
        dos.writeShort(this.parent.y);
        dos.writeShort(this.parent.x);
        int i = 0;
        while (i < this.parent.z) {
            j = 0;
            while (j < this.parent.y) {
                dos.write(this.data[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.parent.z) {
            j = 0;
            while (j < this.parent.y) {
                dos.write(this.extra[i][j]);
                ++j;
            }
            ++i;
        }
        dos.close();
    }

    public void load(File f) throws IllegalArgumentException, IOException {
        int j;
        DataInputStream dis = new DataInputStream(new FileInputStream(f));
        if (dis.readInt() != 1382376531) {
            throw new IllegalArgumentException("Not a redstone file.");
        }
        if (dis.read() > 1) {
            throw new IllegalArgumentException("File has an incompatible version number.");
        }
        int z = dis.readShort();
        int y = dis.readShort();
        short x = dis.readShort();
        this.data = new byte[z][][];
        int i = 0;
        while (i < z) {
            this.data[i] = new byte[y][];
            j = 0;
            while (j < y) {
                this.data[i][j] = new byte[x];
                dis.read(this.data[i][j]);
                ++j;
            }
            ++i;
        }
        this.extra = new byte[z][][];
        i = 0;
        while (i < z) {
            this.extra[i] = new byte[y][];
            j = 0;
            while (j < y) {
                this.extra[i][j] = new byte[x];
                dis.read(this.extra[i][j]);
                ++j;
            }
            ++i;
        }
        dis.close();
        this.parent.setSize(x, y, z);
        this.parent.setLyr(0);
        this.parent.recountRed();
        this.parent.view.repaint();
    }

    public void clone(int[] c) {
        int k;
        int j;
        byte[][][] cdat = new byte[c[5]][][];
        byte[][][] cext = new byte[c[5]][][];
        int i = 0;
        while (i < c[5]) {
            cdat[i] = new byte[c[4]][];
            cext[i] = new byte[c[4]][];
            j = 0;
            while (j < c[4]) {
                cdat[i][j] = new byte[c[3]];
                cext[i][j] = new byte[c[3]];
                k = 0;
                while (k < c[3]) {
                    cdat[i][j][k] = this.data[c[2] + i][c[1] + j][c[0] + k];
                    cext[i][j][k] = this.extra[c[2] + i][c[1] + j][c[0] + k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (c[8] > this.data.length - c[5]) {
            c[8] = this.data.length - c[5];
        }
        if (c[7] > this.data[0].length - c[4]) {
            c[7] = this.data[0].length - c[4];
        }
        if (c[6] > this.data[0][0].length - c[3]) {
            c[6] = this.data[0][0].length - c[3];
        }
        i = 0;
        while (i < c[5]) {
            j = 0;
            while (j < c[4]) {
                k = 0;
                while (k < c[3]) {
                    this.data[c[8] + i][c[7] + j][c[6] + k] = cdat[i][j][k];
                    this.extra[c[8] + i][c[7] + j][c[6] + k] = cext[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.parent.modify();
    }
}

