/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.jnbt.ByteArrayTag;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.EndTag;
import org.jnbt.FloatTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.LongTag;
import org.jnbt.NBTConstants;
import org.jnbt.NBTUtils;
import org.jnbt.ShortTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;

public final class NBTOutputStream
implements Closeable {
    private final DataOutputStream os;

    public NBTOutputStream(OutputStream outputStream) throws IOException {
        this.os = new DataOutputStream(new GZIPOutputStream(outputStream));
    }

    public void writeTag(Tag tag) throws IOException {
        int n = NBTUtils.getTypeCode(tag.getClass());
        String string = tag.getName();
        byte[] byArray = string.getBytes(NBTConstants.CHARSET);
        this.os.writeByte(n);
        this.os.writeShort(byArray.length);
        this.os.write(byArray);
        if (n == 0) {
            throw new IOException("Named TAG_End not permitted.");
        }
        this.writeTagPayload(tag);
    }

    private void writeTagPayload(Tag tag) throws IOException {
        int n = NBTUtils.getTypeCode(tag.getClass());
        switch (n) {
            case 0: {
                this.writeEndTagPayload((EndTag)tag);
                break;
            }
            case 1: {
                this.writeByteTagPayload((ByteTag)tag);
                break;
            }
            case 2: {
                this.writeShortTagPayload((ShortTag)tag);
                break;
            }
            case 3: {
                this.writeIntTagPayload((IntTag)tag);
                break;
            }
            case 4: {
                this.writeLongTagPayload((LongTag)tag);
                break;
            }
            case 5: {
                this.writeFloatTagPayload((FloatTag)tag);
                break;
            }
            case 6: {
                this.writeDoubleTagPayload((DoubleTag)tag);
                break;
            }
            case 7: {
                this.writeByteArrayTagPayload((ByteArrayTag)tag);
                break;
            }
            case 8: {
                this.writeStringTagPayload((StringTag)tag);
                break;
            }
            case 9: {
                this.writeListTagPayload((ListTag)tag);
                break;
            }
            case 10: {
                this.writeCompoundTagPayload((CompoundTag)tag);
                break;
            }
            default: {
                throw new IOException("Invalid tag type: " + n + ".");
            }
        }
    }

    private void writeByteTagPayload(ByteTag byteTag) throws IOException {
        this.os.writeByte(byteTag.getValue().byteValue());
    }

    private void writeByteArrayTagPayload(ByteArrayTag byteArrayTag) throws IOException {
        byte[] byArray = byteArrayTag.getValue();
        this.os.writeInt(byArray.length);
        this.os.write(byArray);
    }

    private void writeCompoundTagPayload(CompoundTag compoundTag) throws IOException {
        for (Tag tag : compoundTag.getValue().values()) {
            this.writeTag(tag);
        }
        this.os.writeByte(0);
    }

    private void writeListTagPayload(ListTag listTag) throws IOException {
        Class<? extends Tag> clazz = listTag.getType();
        Object object = listTag.getValue();
        int n = object.size();
        this.os.writeByte(NBTUtils.getTypeCode(clazz));
        this.os.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeTagPayload((Tag)object.get(i));
        }
    }

    private void writeStringTagPayload(StringTag stringTag) throws IOException {
        byte[] byArray = stringTag.getValue().getBytes(NBTConstants.CHARSET);
        this.os.writeShort(byArray.length);
        this.os.write(byArray);
    }

    private void writeDoubleTagPayload(DoubleTag doubleTag) throws IOException {
        this.os.writeDouble(doubleTag.getValue());
    }

    private void writeFloatTagPayload(FloatTag floatTag) throws IOException {
        this.os.writeFloat(floatTag.getValue().floatValue());
    }

    private void writeLongTagPayload(LongTag longTag) throws IOException {
        this.os.writeLong(longTag.getValue());
    }

    private void writeIntTagPayload(IntTag intTag) throws IOException {
        this.os.writeInt(intTag.getValue());
    }

    private void writeShortTagPayload(ShortTag shortTag) throws IOException {
        this.os.writeShort(shortTag.getValue().shortValue());
    }

    private void writeEndTagPayload(EndTag endTag) {
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

