/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.jnbt.ByteArrayTag;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.EndTag;
import org.jnbt.FloatTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.LongTag;
import org.jnbt.NBTConstants;
import org.jnbt.NBTUtils;
import org.jnbt.ShortTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;

public final class NBTInputStream
implements Closeable {
    private final DataInputStream is;

    public NBTInputStream(InputStream inputStream) throws IOException {
        this.is = new DataInputStream(new GZIPInputStream(inputStream));
    }

    public Tag readTag() throws IOException {
        return this.readTag(0);
    }

    private Tag readTag(int n) throws IOException {
        String string;
        int n2 = this.is.readByte() & 0xFF;
        if (n2 != 0) {
            int n3 = this.is.readShort() & 0xFFFF;
            byte[] byArray = new byte[n3];
            this.is.readFully(byArray);
            string = new String(byArray, NBTConstants.CHARSET);
        } else {
            string = "";
        }
        return this.readTagPayload(n2, string, n);
    }

    private Tag readTagPayload(int n, String string, int n2) throws IOException {
        switch (n) {
            case 0: {
                if (n2 == 0) {
                    throw new IOException("TAG_End found without a TAG_Compound/TAG_List tag preceding it.");
                }
                return new EndTag();
            }
            case 1: {
                return new ByteTag(string, this.is.readByte());
            }
            case 2: {
                return new ShortTag(string, this.is.readShort());
            }
            case 3: {
                return new IntTag(string, this.is.readInt());
            }
            case 4: {
                return new LongTag(string, this.is.readLong());
            }
            case 5: {
                return new FloatTag(string, this.is.readFloat());
            }
            case 6: {
                return new DoubleTag(string, this.is.readDouble());
            }
            case 7: {
                int n3 = ((IntTag)this.readTagPayload(3, "", n2)).getValue();
                byte[] byArray = new byte[n3];
                this.is.readFully(byArray);
                return new ByteArrayTag(string, byArray);
            }
            case 8: {
                short s = ((ShortTag)this.readTagPayload(2, "", n2)).getValue();
                byte[] byArray = new byte[s];
                this.is.readFully(byArray);
                return new StringTag(string, new String(byArray, NBTConstants.CHARSET));
            }
            case 9: {
                byte by = ((ByteTag)this.readTagPayload(1, "", n2)).getValue();
                int n4 = ((IntTag)this.readTagPayload(3, "", n2)).getValue();
                ArrayList<Tag> arrayList = new ArrayList<Tag>();
                for (int i = 0; i < n4; ++i) {
                    Tag tag = this.readTagPayload(by, "", n2 + 1);
                    if (tag instanceof EndTag) {
                        throw new IOException("TAG_End not permitted in a list.");
                    }
                    arrayList.add(tag);
                }
                return new ListTag(string, NBTUtils.getTypeClass(by), arrayList);
            }
            case 10: {
                Tag tag;
                HashMap<String, Tag> hashMap = new HashMap<String, Tag>();
                while (!((tag = this.readTag(n2 + 1)) instanceof EndTag)) {
                    hashMap.put(tag.getName(), tag);
                }
                return new CompoundTag(string, hashMap);
            }
        }
        throw new IOException("Invalid tag type: " + n + ".");
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

