/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforums.osici;

import com.mojang.minecraft.level.Level;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraftforums.osici.Omen;
import org.jnbt.ByteArrayTag;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.LongTag;
import org.jnbt.NBTInputStream;
import org.jnbt.NBTOutputStream;
import org.jnbt.NBTUtils;
import org.jnbt.ShortTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;

public class OmenMap {
    public static Omen oF;
    int mapType;
    short SurroundingGroundHeight;
    byte SurroundingGroundType;
    short SurroundingWaterHeight;
    byte SurroundingWaterType;
    short CloudHeight;
    Color CloudColor;
    Color SkyColor;
    Color FogColor;
    byte SkyBrightness;
    CompoundTag master;
    ListTag entities;
    CompoundTag env;
    CompoundTag mup;
    CompoundTag abt;
    short width;
    short height;
    short length;
    byte[] blocks;
    byte[] data;
    int spawnX;
    int spawnY;
    int spawnZ;
    double rotSpawn = 0.0;
    String name;
    String author;
    long createdOn;

    public OmenMap() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        this.entities = new ListTag("Entities", NBTUtils.getTypeClass(10), arrayList);
        this.SkyBrightness = (byte)100;
        this.CloudHeight = (short)66;
        this.SurroundingWaterHeight = (short)32;
        this.SurroundingGroundHeight = (short)23;
        this.SurroundingGroundType = (byte)2;
        this.SurroundingWaterType = (byte)8;
        this.SkyColor = new Color(153, 204, 255);
        this.FogColor = new Color(255, 255, 255);
        this.CloudColor = new Color(255, 255, 255);
    }

    public OmenMap(File file) {
        if (file.getName().toLowerCase().endsWith(".dat")) {
            this.loadFromDatLevel(file);
        } else if (file.getName().toLowerCase().endsWith(".mclevel")) {
            this.loadMap(file);
        }
    }

    public void loadMap(File file) {
        try {
            NBTInputStream nBTInputStream = new NBTInputStream(new FileInputStream(file));
            CompoundTag compoundTag = (CompoundTag)nBTInputStream.readTag();
            Object object = compoundTag.getValue();
            Object object2 = ((CompoundTag)object.get("Environment")).getValue();
            this.SurroundingGroundHeight = (Short)((Tag)object2.get("SurroundingGroundHeight")).getValue();
            this.SurroundingGroundType = (Byte)((Tag)object2.get("SurroundingGroundType")).getValue();
            this.SurroundingWaterHeight = (Short)((Tag)object2.get("SurroundingWaterHeight")).getValue();
            this.SurroundingWaterType = (Byte)((Tag)object2.get("SurroundingWaterType")).getValue();
            this.CloudHeight = (Short)((Tag)object2.get("CloudHeight")).getValue();
            this.CloudColor = new Color((Integer)((Tag)object2.get("CloudColor")).getValue());
            this.SkyColor = new Color((Integer)((Tag)object2.get("SkyColor")).getValue());
            this.FogColor = new Color((Integer)((Tag)object2.get("FogColor")).getValue());
            this.SkyBrightness = (Byte)((Tag)object2.get("SkyBrightness")).getValue();
            this.entities = (ListTag)object.get("Entities");
            Object object3 = ((CompoundTag)object.get("Map")).getValue();
            List list = (List)((Tag)object3.get("Spawn")).getValue();
            this.spawnX = ((ShortTag)list.get(0)).getValue().shortValue();
            this.spawnY = ((ShortTag)list.get(1)).getValue().shortValue();
            this.spawnZ = ((ShortTag)list.get(2)).getValue().shortValue();
            this.width = (Short)((Tag)object3.get("Width")).getValue();
            this.height = (Short)((Tag)object3.get("Height")).getValue();
            this.length = (Short)((Tag)object3.get("Length")).getValue();
            this.blocks = ((ByteArrayTag)object3.get("Blocks")).getValue();
            this.data = ((ByteArrayTag)object3.get("Data")).getValue();
            Object object4 = ((CompoundTag)object.get("About")).getValue();
            this.name = ((StringTag)object4.get("Name")).getValue();
            this.author = ((StringTag)object4.get("Author")).getValue();
            this.createdOn = (Long)((Tag)object4.get("CreatedOn")).getValue();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveMapFile(File file) {
        if (file.getName().toLowerCase().endsWith(".mclevel")) {
            this.saveMCLevel(file);
        } else {
            this.saveToDatLevel(file);
        }
    }

    public void saveMCLevel(File file) {
        try {
            NBTOutputStream nBTOutputStream = new NBTOutputStream(new FileOutputStream(file));
            HashMap<String, Tag> hashMap = new HashMap<String, Tag>();
            for (int i = 0; i < this.blocks.length; ++i) {
                if (this.blocks[i] != 50 || this.data[i] != 0) continue;
                this.data[i] = 13;
            }
            HashMap<String, Tag> hashMap2 = new HashMap<String, Tag>();
            ShortTag shortTag = new ShortTag("SurroundingGroundHeight", this.SurroundingGroundHeight);
            ByteTag byteTag = new ByteTag("SurroundingGroundType", this.SurroundingGroundType);
            ShortTag shortTag2 = new ShortTag("SurroundingWaterHeight", this.SurroundingWaterHeight);
            ByteTag byteTag2 = new ByteTag("SurroundingWaterType", this.SurroundingWaterType);
            ShortTag shortTag3 = new ShortTag("CloudHeight", this.CloudHeight);
            IntTag intTag = new IntTag("CloudColor", this.CloudColor.getRGB());
            IntTag intTag2 = new IntTag("SkyColor", this.SkyColor.getRGB());
            IntTag intTag3 = new IntTag("FogColor", this.FogColor.getRGB());
            ByteTag byteTag3 = new ByteTag("SkyBrightness", this.SkyBrightness);
            hashMap2.put(shortTag.getName(), shortTag);
            hashMap2.put(byteTag.getName(), byteTag);
            hashMap2.put(shortTag2.getName(), shortTag2);
            hashMap2.put(byteTag2.getName(), byteTag2);
            hashMap2.put(shortTag3.getName(), shortTag3);
            hashMap2.put(intTag.getName(), intTag);
            hashMap2.put(intTag2.getName(), intTag2);
            hashMap2.put(intTag3.getName(), intTag3);
            hashMap2.put(byteTag3.getName(), byteTag3);
            CompoundTag compoundTag = new CompoundTag("Environment", hashMap2);
            HashMap<String, Tag> hashMap3 = new HashMap<String, Tag>();
            ShortTag shortTag4 = new ShortTag("Width", this.width);
            ShortTag shortTag5 = new ShortTag("Height", this.height);
            ShortTag shortTag6 = new ShortTag("Length", this.length);
            ByteArrayTag byteArrayTag = new ByteArrayTag("Blocks", this.blocks);
            ByteArrayTag byteArrayTag2 = new ByteArrayTag("Data", this.data);
            ArrayList<Tag> arrayList = new ArrayList<Tag>();
            ShortTag shortTag7 = new ShortTag("", (short)this.spawnX);
            ShortTag shortTag8 = new ShortTag("", (short)this.spawnY);
            ShortTag shortTag9 = new ShortTag("", (short)this.spawnZ);
            arrayList.add(shortTag7);
            arrayList.add(shortTag8);
            arrayList.add(shortTag9);
            ListTag listTag = new ListTag("Spawn", NBTUtils.getTypeClass(2), arrayList);
            hashMap3.put(shortTag4.getName(), shortTag4);
            hashMap3.put(shortTag5.getName(), shortTag5);
            hashMap3.put(shortTag6.getName(), shortTag6);
            hashMap3.put(byteArrayTag.getName(), byteArrayTag);
            hashMap3.put(byteArrayTag2.getName(), byteArrayTag2);
            hashMap3.put(listTag.getName(), listTag);
            CompoundTag compoundTag2 = new CompoundTag("Map", hashMap3);
            HashMap<String, Tag> hashMap4 = new HashMap<String, Tag>();
            StringTag stringTag = new StringTag("Name", this.name);
            StringTag stringTag2 = new StringTag("Author", this.author);
            LongTag longTag = new LongTag("CreatedOn", this.createdOn);
            hashMap4.put(stringTag.getName(), stringTag);
            hashMap4.put(stringTag2.getName(), stringTag2);
            hashMap4.put(longTag.getName(), longTag);
            CompoundTag compoundTag3 = new CompoundTag("About", hashMap4);
            hashMap.put(compoundTag.getName(), compoundTag);
            hashMap.put(this.entities.getName(), this.entities);
            hashMap.put(compoundTag2.getName(), compoundTag2);
            hashMap.put(compoundTag3.getName(), compoundTag3);
            CompoundTag compoundTag4 = new CompoundTag("MinecraftLevel", hashMap);
            nBTOutputStream.writeTag(compoundTag4);
            nBTOutputStream.close();
            oF.println("File Saved to '" + file.getName() + "' successfully.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean saveToDatLevel(File file) {
        try {
            Level level = new Level();
            level.name = this.name;
            level.creator = this.author;
            level.createTime = this.createdOn;
            level.width = this.width;
            level.height = this.length;
            level.depth = this.height;
            level.xSpawn = this.spawnX;
            level.ySpawn = this.spawnY;
            level.zSpawn = this.spawnZ;
            level.rotSpawn = (float)this.rotSpawn;
            level.blocks = this.blocks;
            boolean bl = false;
            for (int i = 0; i < level.blocks.length; ++i) {
                if (level.blocks[i] <= 49) continue;
                bl = true;
            }
            if (bl) {
                oF.println("Warning: Multiplayer map contains indev blocks. These may not be supported.");
            }
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[]{39, 27, -73, -120, 2};
            gZIPOutputStream.write(byArray, 0, byArray.length);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(level);
            objectOutputStream.close();
            gZIPOutputStream.close();
            oF.println("File Saved to '" + file.getName() + "' successfully.");
        }
        catch (IOException iOException) {
            oF.println("Unable to save file.");
            iOException.printStackTrace();
        }
        return false;
    }

    public boolean loadFromDatLevel(File file) {
        try {
            ListTag listTag;
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(file));
            byte[] byArray = new byte[5];
            gZIPInputStream.read(byArray, 0, byArray.length);
            if (byArray[0] != 39 || byArray[1] != 27 || byArray[2] != -73 || byArray[3] != -120) {
                oF.println("Unsupported file type. Level not loaded." + byArray[0] + " " + byArray[1] + " " + byArray[2] + " " + byArray[3]);
                return false;
            }
            if (byArray[4] > 2) {
                oF.println("Multiplayer Level version " + byArray[4] + " detected. This editor supports version 2.");
                return false;
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            Level level = (Level)objectInputStream.readObject();
            level.initTransient();
            this.blocks = level.blocks;
            this.data = new byte[level.width * level.depth * level.height];
            this.spawnX = level.xSpawn;
            this.spawnY = level.ySpawn;
            this.spawnZ = level.zSpawn;
            this.width = (short)level.width;
            this.height = (short)level.depth;
            this.length = (short)level.height;
            this.rotSpawn = level.rotSpawn;
            this.name = level.name;
            this.author = level.creator;
            this.createdOn = level.createTime;
            this.SkyColor = new Color(153, 204, 255);
            this.FogColor = new Color(255, 255, 255);
            this.CloudColor = new Color(255, 255, 255);
            this.SkyBrightness = (byte)100;
            this.CloudHeight = (short)66;
            this.SurroundingWaterType = (byte)8;
            this.SurroundingGroundType = (byte)2;
            this.SurroundingWaterHeight = (short)32;
            this.SurroundingGroundHeight = (short)23;
            ArrayList<Tag> arrayList = new ArrayList<Tag>();
            this.entities = listTag = new ListTag("Entities", NBTUtils.getTypeClass(10), arrayList);
            gZIPInputStream.close();
            objectInputStream.close();
            oF.println("Multiplayer Level " + file.getName() + " loaded successfully.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            oF.println("Unable to load level file: " + file.getName());
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            oF.println("Unable to load level file: " + file.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            oF.println("Unable to find the level class. Check whether minecraft-server.jar is in your classpath.");
        }
        return false;
    }

    public String toString() {
        return "OmenMap";
    }
}

