/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforums.osici;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.minecraftforums.osici.Omen;
import net.minecraftforums.osici.OmenMap;

public class NewMapBox
extends JFrame
implements ActionListener,
ChangeListener {
    String[] flatPresets = new String[]{"Grass", "Rock", "Sand", "Water", "Shallow Water", "Frozen Water", "Snow", "Lava"};
    String[] randomPresets = new String[]{"Grassland", "Desert", "Winter", "Hell", "Mountain", "Caverns", "Ruins"};
    JTextField[] textFields;
    ButtonGroup mapTypeGroup;
    JRadioButton blankRB;
    JRadioButton flatRB;
    JComboBox flatList;
    JRadioButton randomRB;
    JComboBox randomList;
    JCheckBox floodBarrier;
    JCheckBox lavaBox;
    JCheckBox waterBox;
    JCheckBox treeBox;
    JCheckBox cavesBox;
    JSlider heightScale;
    JSlider heightOffset;
    JSlider smoothness;
    JLabel previewLabel;
    JLabel heightScaleLabel;
    JLabel groundHeightLabel;
    JLabel smoothnessLabel;
    ImageIcon[] presetIcons;
    Omen oF;

    public void setLayer(int n, int n2) {
        if ((n = this.oF.ny - 1 - n) >= 0 && n < this.oF.ny) {
            for (int i = 0; i < this.oF.nx; ++i) {
                for (int j = 0; j < this.oF.nz; ++j) {
                    this.oF.map.blocks[i + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n) + this.oF.nx * j] = (byte)n2;
                }
            }
        }
    }

    double[][] smoothArray(double[][] dArray) {
        int n;
        int n2;
        int n3 = dArray.length;
        double[][] dArray2 = new double[n3][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray2[n2][n] = dArray[n2][n];
            }
        }
        for (n2 = 1; n2 < n3 - 1; ++n2) {
            for (n = 1; n < n3 - 1; ++n) {
                dArray2[n2][n] = 0.5 * dArray[n2][n] + 0.125 * (dArray[n2 + 1][n] + dArray[n2 - 1][n] + dArray[n2][n + 1] + dArray[n2][n - 1]);
            }
        }
        for (n2 = 1; n2 < n3 - 1; ++n2) {
            dArray2[0][n2] = 0.5 * dArray[0][n2] + 0.1666667 * (dArray[1][n2] + dArray[0][n2 + 1] + dArray[0][n2 - 1]);
            dArray2[n3 - 1][n2] = 0.5 * dArray[0][n2] + 0.1666667 * (dArray[n3 - 2][n2] + dArray[n3 - 1][n2 + 1] + dArray[n3 - 1][n2 - 1]);
        }
        for (n2 = 1; n2 < n3 - 1; ++n2) {
            dArray2[n2][0] = 0.5 * dArray[n2][0] + 0.1666667 * (dArray[n2][1] + dArray[n2 + 1][0] + dArray[n2 - 1][0]);
            dArray2[n2][n3 - 1] = 0.5 * dArray[n2][n3 - 1] + 0.1666667 * (dArray[n2][n3 - 2] + dArray[n2 + 1][n3 - 1] + dArray[n2 - 1][n3 - 1]);
        }
        return dArray2;
    }

    public void spreadType(int n, int n2, double d) {
        int n3;
        int n4;
        double[][] dArray = new double[this.oF.nx][this.oF.nz];
        for (n4 = 0; n4 < this.oF.nx; ++n4) {
            for (n3 = 0; n3 < this.oF.nz; ++n3) {
                dArray[n4][n3] = this.oF.map.blocks[n4 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n) + this.oF.nx * n3];
            }
        }
        for (n4 = 1; n4 < this.oF.nx - 1; ++n4) {
            for (n3 = 1; n3 < this.oF.nz - 1; ++n3) {
                if (dArray[n4 - 1][n3] != (double)n2 && dArray[n4 + 1][n3] != (double)n2 && dArray[n4][n3 + 1] != (double)n2 && dArray[n4][n3 - 1] != (double)n2 || !(Math.random() < d)) continue;
                this.oF.map.blocks[n4 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n) + this.oF.nx * n3] = (byte)n2;
            }
        }
    }

    public void removeTop(int n) {
        for (int i = 1; i < this.oF.nx - 1; ++i) {
            for (int j = 1; j < this.oF.ny - 1; ++j) {
                for (int k = 1; k < this.oF.nz - 1; ++k) {
                    if ((this.oF.map.blocks[i + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (j - 1)) + this.oF.nx * k] != 0 || this.oF.map.blocks[i + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (j + 1)) + this.oF.nx * k] != n || this.oF.map.blocks[i + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - j) + this.oF.nx * k] == 8) && (this.oF.map.blocks[i + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (j - 1)) + this.oF.nx * k] != 0 || this.oF.map.blocks[i + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (j + 1)) + this.oF.nx * k] != n || this.oF.map.blocks[i + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - j) + this.oF.nx * k] == 8)) continue;
                    this.oF.map.blocks[i + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - j) + this.oF.nx * k] = (byte)n;
                }
            }
        }
    }

    public double[][] voronoiField(int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        double d = bl2 ? 1.0 : 0.0;
        int n6 = 1;
        for (n5 = 1; n5 < this.oF.nx; n5 *= 2) {
        }
        while (n6 < this.oF.nz) {
            n6 *= 2;
        }
        int n7 = n5 > n6 ? n5 : n6;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        for (n4 = 0; n4 < n; ++n4) {
            dArray[n4] = (double)this.oF.nx * Math.random();
            dArray2[n4] = (double)this.oF.nz * Math.random();
            dArray4[n4] = Math.random();
            dArray3[n4] = dArray4[n4];
        }
        if (bl) {
            for (n4 = 0; n4 < n; ++n4) {
                n3 = 0;
                n2 = 0;
                double d2 = Double.MAX_VALUE;
                for (int i = 0; i < n; ++i) {
                    double d3;
                    if (n4 == i || !((d3 = Math.pow(dArray[n4] - dArray[i], 2.0) + Math.pow(dArray2[n4] - dArray2[i], 2.0)) < d2)) continue;
                    d2 = d3;
                    n2 = n3;
                    n3 = i;
                }
                dArray3[n4] = 0.6 * dArray4[n4] + 0.25 * dArray4[n3] + 0.15 * dArray4[n2];
            }
        }
        double[][] dArray5 = new double[n7 + 1][n7 + 1];
        for (n3 = 0; n3 < n7; ++n3) {
            for (n2 = 0; n2 < n7; ++n2) {
                int n8 = 0;
                double d4 = Double.MAX_VALUE;
                for (int i = 0; i < n; ++i) {
                    double d5 = Math.pow(dArray[i] + d * (10.0 * Math.random() - 5.0) - (double)n3, 2.0) + Math.pow(dArray2[i] + d * (10.0 * Math.random() - 5.0) - (double)n2, 2.0);
                    if (!(d5 < d4)) continue;
                    d4 = d5;
                    n8 = i;
                }
                dArray5[n3][n2] = dArray3[n8];
            }
        }
        return dArray5;
    }

    public double[][] voronoiDistanceField(int n, boolean bl, boolean bl2) {
        int n2;
        double d = bl2 ? 1.0 : 0.0;
        int n3 = 1;
        for (n2 = 1; n2 < this.oF.nx; n2 *= 2) {
        }
        while (n3 < this.oF.nz) {
            n3 *= 2;
        }
        int n4 = n2 > n3 ? n2 : n3;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)this.oF.nx * Math.random();
            dArray2[i] = (double)this.oF.nz * Math.random();
        }
        double[][] dArray3 = new double[n4 + 1][n4 + 1];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n5 = 0;
                double d2 = Double.MAX_VALUE;
                for (int k = 0; k < n; ++k) {
                    double d3 = Math.pow(dArray[k] + d * (10.0 * Math.random() - 5.0) - (double)i, 2.0) + Math.pow(dArray2[k] + d * (10.0 * Math.random() - 5.0) - (double)j, 2.0);
                    if (!(d3 < d2)) continue;
                    d2 = d3;
                    n5 = k;
                }
                dArray3[i][j] = d2;
            }
        }
        return dArray3;
    }

    public double[][] despeckle(double[][] dArray) {
        int n;
        int n2;
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[0].length; ++n) {
                dArray2[n2][n] = dArray[n2][n];
                if (dArray[n2][n] > d) {
                    d = dArray[n2][n];
                }
                if (!(dArray[n2][n] < d2)) continue;
                d2 = dArray[n2][n];
            }
        }
        for (n2 = 1; n2 < dArray.length - 1; ++n2) {
            for (n = 1; n < dArray[0].length - 1; ++n) {
                int n3;
                int[] nArray = new int[this.oF.ny];
                double[] dArray3 = new double[this.oF.ny];
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    nArray[n3] = 0;
                }
                int n4 = (int)(0.8 * (double)this.oF.ny * (dArray[n2][n] - d2) / (d - d2));
                nArray[n4] = nArray[n4] + 1;
                int n5 = (int)(0.8 * (double)this.oF.ny * (dArray[n2][n - 1] - d2) / (d - d2));
                nArray[n5] = nArray[n5] + 1;
                int n6 = (int)(0.8 * (double)this.oF.ny * (dArray[n2][n + 1] - d2) / (d - d2));
                nArray[n6] = nArray[n6] + 1;
                int n7 = (int)(0.8 * (double)this.oF.ny * (dArray[n2 + 1][n] - d2) / (d - d2));
                nArray[n7] = nArray[n7] + 1;
                int n8 = (int)(0.8 * (double)this.oF.ny * (dArray[n2 + 1][n + 1] - d2) / (d - d2));
                nArray[n8] = nArray[n8] + 1;
                int n9 = (int)(0.8 * (double)this.oF.ny * (dArray[n2 + 1][n - 1] - d2) / (d - d2));
                nArray[n9] = nArray[n9] + 1;
                int n10 = (int)(0.8 * (double)this.oF.ny * (dArray[n2 - 1][n] - d2) / (d - d2));
                nArray[n10] = nArray[n10] + 1;
                int n11 = (int)(0.8 * (double)this.oF.ny * (dArray[n2 - 1][n + 1] - d2) / (d - d2));
                nArray[n11] = nArray[n11] + 1;
                int n12 = (int)(0.8 * (double)this.oF.ny * (dArray[n2 - 1][n - 1] - d2) / (d - d2));
                nArray[n12] = nArray[n12] + 1;
                dArray3[(int)(0.8 * (double)this.oF.ny * (dArray[n2][n] - d2) / (d - d2))] = dArray[n2][n];
                dArray3[(int)(0.8 * (double)this.oF.ny * (dArray[n2][n - 1] - d2) / (d - d2))] = dArray[n2][n - 1];
                dArray3[(int)(0.8 * (double)this.oF.ny * (dArray[n2][n + 1] - d2) / (d - d2))] = dArray[n2][n + 1];
                dArray3[(int)(0.8 * (double)this.oF.ny * (dArray[n2 + 1][n] - d2) / (d - d2))] = dArray[n2 + 1][n];
                dArray3[(int)(0.8 * (double)this.oF.ny * (dArray[n2 + 1][n + 1] - d2) / (d - d2))] = dArray[n2 + 1][n + 1];
                dArray3[(int)(0.8 * (double)this.oF.ny * (dArray[n2 + 1][n - 1] - d2) / (d - d2))] = dArray[n2 + 1][n - 1];
                dArray3[(int)(0.8 * (double)this.oF.ny * (dArray[n2 - 1][n] - d2) / (d - d2))] = dArray[n2 - 1][n];
                dArray3[(int)(0.8 * (double)this.oF.ny * (dArray[n2 - 1][n + 1] - d2) / (d - d2))] = dArray[n2 - 1][n + 1];
                dArray3[(int)(0.8 * (double)this.oF.ny * (dArray[n2 - 1][n - 1] - d2) / (d - d2))] = dArray[n2 - 1][n - 1];
                n3 = 0;
                int n13 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] <= n3) continue;
                    n3 = nArray[i];
                    n13 = i;
                }
                dArray2[n2][n] = dArray3[n13];
            }
        }
        return dArray2;
    }

    public double[][] makeTerrain(int n, int n2, long l) {
        int n3;
        Random random = new Random(l);
        int n4 = 1;
        for (n3 = 1; n3 < this.oF.nx; n3 *= 2) {
        }
        while (n4 < this.oF.nz) {
            n4 *= 2;
        }
        int n5 = n3 > n4 ? n3 : n4;
        double[][] dArray = new double[n5 + 1][n5 + 1];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n5; ++j) {
                dArray[i][j] = -1.0;
            }
        }
        dArray[0][0] = 0.0;
        dArray[0][n5] = 0.0;
        dArray[n5][0] = 0.0;
        dArray[n5][n5] = 0.0;
        this.midPointDisplacement(0, 0, n5, 1, dArray, random);
        return dArray;
    }

    public void midPointDisplacement(int n, int n2, int n3, int n4, double[][] dArray, Random random) {
        double d;
        if (n3 < 1) {
            return;
        }
        if (dArray[n + n3 / 2][n2] == -1.0) {
            d = (dArray[n + n3][n2] + dArray[n][n2]) / 2.0;
            dArray[n + n3 / 2][n2] = d + (random.nextDouble() - 0.5) / (double)(2 * n4);
        }
        if (dArray[n][n2 + n3 / 2] == -1.0) {
            d = (dArray[n][n2 + n3] + dArray[n][n2]) / 2.0;
            dArray[n][n2 + n3 / 2] = d + (random.nextDouble() - 0.5) / (double)(2 * n4);
        }
        if (dArray[n + n3][n2 + n3 / 2] == -1.0) {
            d = (dArray[n + n3][n2 + n3] + dArray[n + n3][n2]) / 2.0;
            dArray[n + n3][n2 + n3 / 2] = d + (random.nextDouble() - 0.5) / (double)(2 * n4);
        }
        if (dArray[n + n3 / 2][n2 + n3] == -1.0) {
            d = (dArray[n + n3][n2 + n3] + dArray[n][n2 + n3]) / 2.0;
            dArray[n + n3 / 2][n2 + n3] = d + (random.nextDouble() - 0.5) / (double)(2 * n4);
        }
        if (dArray[n + n3 / 2][n2 + n3 / 2] == -1.0) {
            d = (dArray[n + n3 / 2][n2] + dArray[n][n2 + n3 / 2] + dArray[n + n3][n2 + n3 / 2] + dArray[n + n3 / 2][n2 + n3]) / 4.0;
            dArray[n + n3 / 2][n2 + n3 / 2] = d + (random.nextDouble() - 0.5) / (double)(2 * n4);
        }
        this.midPointDisplacement(n + n3 / 2, n2 + n3 / 2, n3 / 2, n4 + 1, dArray, random);
        this.midPointDisplacement(n, n2, n3 / 2, n4 + 1, dArray, random);
        this.midPointDisplacement(n + n3 / 2, n2, n3 / 2, n4 + 1, dArray, random);
        this.midPointDisplacement(n, n2 + n3 / 2, n3 / 2, n4 + 1, dArray, random);
    }

    public void grasslandMap(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        double[][] dArray = this.makeTerrain(1, 1, (long)(2.147483647E9 * Math.random()));
        double[][] dArray2 = this.despeckle(this.despeckle(this.voronoiField(100, true, true)));
        double[][] dArray3 = this.despeckle(this.despeckle(this.voronoiField(10, false, true)));
        double d = dArray[0][0];
        double d2 = dArray[0][0];
        for (n7 = 0; n7 < this.smoothness.getValue(); ++n7) {
            dArray = this.despeckle(this.smoothArray(dArray));
        }
        for (n7 = 0; n7 < dArray.length; ++n7) {
            for (n6 = 0; n6 < dArray.length; ++n6) {
                dArray[n7][n6] = 0.1 + 0.5 * dArray2[n7][n6] + 0.8 * dArray[n7][n6] + 0.2 * dArray3[n7][n6];
            }
        }
        for (n7 = 0; n7 < dArray.length; ++n7) {
            for (n6 = 0; n6 < dArray.length; ++n6) {
                d = d > dArray[n7][n6] ? d : dArray[n7][n6];
                d2 = d2 < dArray[n7][n6] ? d2 : dArray[n7][n6];
            }
        }
        for (n7 = 0; n7 < dArray.length; ++n7) {
            for (n6 = 0; n6 < dArray.length; ++n6) {
                dArray[n7][n6] = (dArray[n7][n6] - d2) / (d - d2) - 0.5;
            }
        }
        for (n7 = 0; n7 < this.oF.nx; ++n7) {
            for (n6 = 0; n6 < this.oF.nz; ++n6) {
                n5 = (int)((double)n + (double)n * dArray[n7][n6] * (0.04 * (double)this.heightScale.getValue()) + (double)(this.heightOffset.getValue() * this.oF.ny) / 20.0);
                for (n4 = 0; n4 < n5 - 4; ++n4) {
                    if (this.oF.ny - 1 - n4 < 0 || this.oF.ny - 1 - n4 >= this.oF.ny) continue;
                    this.oF.map.blocks[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n4)) + this.oF.nx * n6] = 1;
                }
                if (this.waterBox.isSelected() && n5 < this.oF.ny / 2) {
                    for (n4 = n5 - 4; n4 < n5 - 2; ++n4) {
                        if (this.oF.ny - 1 - n4 < 0 || this.oF.ny - 1 - n4 >= this.oF.ny) continue;
                        this.oF.map.blocks[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n4)) + this.oF.nx * n6] = 3;
                    }
                    for (n4 = n5 - 2; n4 < n5; ++n4) {
                        if (this.oF.ny - 1 - n4 < 0 || this.oF.ny - 1 - n4 >= this.oF.ny) continue;
                        this.oF.map.blocks[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n4)) + this.oF.nx * n6] = 13;
                    }
                    for (n4 = n5; n4 <= this.oF.ny / 2 - 1; ++n4) {
                        if (this.oF.ny - 1 - n4 < 0 || this.oF.ny - 1 - n4 >= this.oF.ny) continue;
                        this.oF.map.blocks[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n4)) + this.oF.nx * n6] = 8;
                    }
                    continue;
                }
                for (n4 = n5 - 4; n4 < n5 - 1; ++n4) {
                    if (this.oF.ny - 1 - n4 < 0 || this.oF.ny - 1 - n4 >= this.oF.ny) continue;
                    this.oF.map.blocks[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n4)) + this.oF.nx * n6] = 3;
                }
                if (this.oF.ny - n5 < 0 || this.oF.ny - n5 >= this.oF.ny) continue;
                this.oF.map.blocks[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - n5)) + this.oF.nx * n6] = n5 == this.oF.ny / 2 ? 12 : 2;
            }
        }
        n7 = this.oF.currentView;
        this.oF.currentView = 1;
        n6 = this.oF.vy;
        n5 = this.oF.typeNo;
        this.oF.typeNo = (byte)2;
        this.oF.vy = this.oF.ny / 2;
        for (n4 = 0; n4 < 100; ++n4) {
            n3 = (int)((double)this.oF.nx * Math.random());
            if (this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - this.oF.ny / 2) + this.oF.nx * (n2 = (int)((double)this.oF.nz * Math.random()))] != 12) continue;
            this.oF.floodFill2d(n3, n2);
        }
        this.oF.typeNo = n5;
        this.oF.currentView = n7;
        this.oF.vy = n6;
        if (this.treeBox.isSelected()) {
            for (n4 = 0; n4 < 8; ++n4) {
                this.oF.randomWood(2);
            }
        }
        for (n4 = 0; n4 < 8; ++n4) {
            this.oF.randomPlants(38, 2, (int)(2.0 + 50.0 * Math.random()));
        }
        for (n4 = 0; n4 < 9; ++n4) {
            this.oF.randomPlants(37, 2, (int)(2.0 + 50.0 * Math.random()));
        }
        if (this.cavesBox.isSelected()) {
            if (this.lavaBox.isSelected()) {
                for (n4 = 0; n4 < 8; ++n4) {
                    this.oF.addSingleCave(1, 10, 30, 0.05);
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    this.oF.addSingleVein(1, 10, 1000, 0.015, 1);
                }
            }
            if (this.waterBox.isSelected()) {
                for (n4 = 0; n4 < 8; ++n4) {
                    this.oF.addSingleCave(1, 8, 30, 0.05);
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    this.oF.addSingleVein(1, 8, 1000, 0.015, 1);
                }
            }
            for (n4 = 0; n4 < 12; ++n4) {
                this.oF.addSingleCave(1, 0, 30, 0.05);
            }
            for (n4 = 0; n4 < 3; ++n4) {
                this.oF.addSingleVein(1, 0, 500, 0.015, 1);
            }
            for (n4 = 0; n4 < 10; ++n4) {
                this.oF.addSingleVein(1, 0, 300, 0.03, 1, 20);
            }
            for (n4 = 0; n4 < 12; ++n4) {
                this.oF.addSingleCave(1, 16, 500, 0.03);
            }
            for (n4 = 0; n4 < 32; ++n4) {
                this.oF.addSingleVein(1, 16, 200, 0.015, 1);
            }
            for (n4 = 0; n4 < 32; ++n4) {
                this.oF.addSingleCave(1, 15, 500, 0.02);
            }
            for (n4 = 0; n4 < 8; ++n4) {
                this.oF.addSingleVein(1, 15, 200, 0.015, 1);
            }
            for (n4 = 0; n4 < 20; ++n4) {
                this.oF.addSingleCave(1, 14, 400, 0.0175);
            }
            for (n4 = 0; n4 < 8; ++n4) {
                this.oF.addSingleVein(1, 14, 200, 0.015, 1);
            }
            for (n4 = 0; n4 < 20; ++n4) {
                this.oF.addSingleCave(1, 56, 1000, 0.01564);
            }
            for (n4 = 0; n4 < this.oF.nx; ++n4) {
                for (n3 = 0; n3 < this.oF.ny; ++n3) {
                    for (n2 = 0; n2 < this.oF.nz; ++n2) {
                        if (this.oF.map.blocks[n4 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n3) + this.oF.nx * n2] != 21) continue;
                        this.oF.map.blocks[n4 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n3) + this.oF.nx * n2] = 1;
                    }
                }
            }
            this.oF.sealLiquids(1);
        }
        if (this.lavaBox.isSelected()) {
            this.setLayer(0, 10);
        }
    }

    public void makeNewMap() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long l = System.currentTimeMillis();
        String string = "Blank";
        if (this.flatRB.isSelected()) {
            string = (String)this.flatList.getSelectedItem();
        } else if (this.randomRB.isSelected()) {
            string = (String)this.randomList.getSelectedItem();
        }
        OmenMap omenMap = new OmenMap();
        omenMap.name = this.textFields[0].getText();
        omenMap.author = this.textFields[1].getText();
        omenMap.createdOn = System.currentTimeMillis();
        omenMap.width = Short.parseShort(this.textFields[2].getText());
        omenMap.height = Short.parseShort(this.textFields[3].getText());
        omenMap.length = Short.parseShort(this.textFields[4].getText());
        omenMap.spawnX = Integer.parseInt(this.textFields[5].getText());
        omenMap.spawnY = Integer.parseInt(this.textFields[6].getText());
        omenMap.spawnZ = Integer.parseInt(this.textFields[7].getText());
        omenMap.rotSpawn = Float.parseFloat(this.textFields[8].getText());
        this.oF.map = omenMap;
        this.oF.nx = omenMap.width;
        this.oF.ny = omenMap.height;
        this.oF.map.CloudHeight = (short)(this.oF.ny + 2);
        this.oF.map.SurroundingWaterHeight = (short)(this.oF.ny / 2);
        this.oF.map.SurroundingGroundHeight = (short)(this.oF.ny / 2 - 9);
        this.oF.nz = omenMap.length;
        this.oF.map.blocks = new byte[this.oF.nx * this.oF.ny * this.oF.nz];
        this.oF.map.data = new byte[this.oF.nx * this.oF.ny * this.oF.nz];
        this.oF.undoGrid = new byte[this.oF.nx * this.oF.ny * this.oF.nz];
        this.oF.changed = new boolean[this.oF.nx * this.oF.ny * this.oF.nz];
        for (n6 = 0; n6 < this.oF.nx; ++n6) {
            for (n5 = 0; n5 < this.oF.ny; ++n5) {
                for (n4 = 0; n4 < this.oF.nz; ++n4) {
                    this.oF.map.blocks[n6 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n5) + this.oF.nx * n4] = 0;
                    this.oF.map.data[n6 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n5) + this.oF.nx * n4] = 0;
                    this.oF.undoGrid[n6 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n5) + this.oF.nx * n4] = 0;
                }
            }
        }
        n6 = this.oF.ny / 2;
        if (string == "Grass") {
            for (n5 = 0; n5 < n6 - 11; ++n5) {
                this.setLayer(n5, 1);
            }
            for (n5 = n6 - 11; n5 < n6 - 1; ++n5) {
                this.setLayer(n5, 3);
            }
            for (n5 = n6 - 1; n5 < n6; ++n5) {
                this.setLayer(n5, 2);
            }
        } else if (string == "Rock") {
            for (n5 = 0; n5 < n6; ++n5) {
                this.setLayer(n5, 1);
            }
        } else if (string == "Sand") {
            for (n5 = 0; n5 < n6 - 11; ++n5) {
                this.setLayer(n5, 1);
            }
            for (n5 = n6 - 11; n5 < n6; ++n5) {
                this.setLayer(n5, 12);
            }
        } else if (string == "Water") {
            for (n5 = 0; n5 < 1; ++n5) {
                this.setLayer(n5, 12);
            }
            for (n5 = 1; n5 < n6; ++n5) {
                this.setLayer(n5, 8);
            }
        } else if (string == "Shallow Water") {
            for (n5 = 0; n5 < n6 - 1; ++n5) {
                this.setLayer(n5, 12);
            }
            for (n5 = n6 - 1; n5 < n6; ++n5) {
                this.setLayer(n5, 8);
            }
        } else if (string == "Frozen Water") {
            for (n5 = 0; n5 < n6 - 1; ++n5) {
                this.setLayer(n5, 8);
            }
            for (n5 = n6 - 1; n5 < n6; ++n5) {
                this.setLayer(n5, 20);
            }
        } else if (string == "Snow") {
            omenMap.SkyColor = new Color(153, 153, 255);
            omenMap.FogColor = new Color(214, 214, 255);
            for (n5 = 0; n5 < n6 - 11; ++n5) {
                this.setLayer(n5, 1);
            }
            for (n5 = n6 - 11; n5 < n6 - 1; ++n5) {
                this.setLayer(n5, 3);
            }
            for (n5 = n6 - 1; n5 < n6; ++n5) {
                this.setLayer(n5, 36);
            }
        } else if (string == "Lava") {
            for (n5 = 0; n5 < 1; ++n5) {
                this.setLayer(n5, 1);
            }
            for (n5 = 1; n5 < n6; ++n5) {
                this.setLayer(n5, 10);
            }
            omenMap.SkyColor = new Color(16, 4, 0);
            omenMap.CloudColor = new Color(33, 8, 0);
            omenMap.FogColor = new Color(16, 4, 0);
            omenMap.SkyBrightness = (byte)50;
            omenMap.SurroundingWaterType = (byte)10;
        } else if (string == "Grassland") {
            this.grasslandMap(n6);
        } else if (string == "Desert") {
            int n7;
            int n8;
            double[][] dArray = this.voronoiDistanceField(100, false, false);
            double d = dArray[0][0];
            double d2 = dArray[0][0];
            for (n3 = 0; n3 < dArray.length; ++n3) {
                for (n8 = 0; n8 < dArray.length; ++n8) {
                    d = d > dArray[n3][n8] ? d : dArray[n3][n8];
                    d2 = d2 < dArray[n3][n8] ? d2 : dArray[n3][n8];
                }
            }
            for (n3 = 0; n3 < dArray.length; ++n3) {
                for (n8 = 0; n8 < dArray.length; ++n8) {
                    dArray[n3][n8] = (dArray[n3][n8] - d2) / (d - d2) - 0.5;
                }
            }
            for (n3 = 0; n3 < this.smoothness.getValue(); ++n3) {
                dArray = this.smoothArray(dArray);
            }
            for (n3 = 0; n3 < this.oF.nx; ++n3) {
                for (n8 = 0; n8 < this.oF.nz; ++n8) {
                    int n9;
                    n7 = (int)((double)n6 + (double)n6 * dArray[n3][n8] * (0.04 * (double)this.heightScale.getValue()) + (double)(this.heightOffset.getValue() * this.oF.ny) / 20.0);
                    for (n9 = 0; n9 < n7 - 7; ++n9) {
                        if (this.oF.ny - 1 - n9 < 0 || this.oF.ny - 1 - n9 >= this.oF.ny) continue;
                        this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n9)) + this.oF.nx * n8] = 1;
                    }
                    if (this.waterBox.isSelected() && n7 < this.oF.ny / 2) {
                        for (n9 = n7 - 7; n9 < n7 - 2; ++n9) {
                            if (this.oF.ny - 1 - n9 < 0 || this.oF.ny - 1 - n9 >= this.oF.ny) continue;
                            this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n9)) + this.oF.nx * n8] = 3;
                        }
                        for (n9 = n7 - 2; n9 < n7; ++n9) {
                            if (this.oF.ny - 1 - n9 < 0 || this.oF.ny - 1 - n9 >= this.oF.ny) continue;
                            this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n9)) + this.oF.nx * n8] = 12;
                        }
                        for (n9 = n7; n9 <= this.oF.ny / 2 - 1; ++n9) {
                            if (this.oF.ny - 1 - n9 < 0 || this.oF.ny - 1 - n9 >= this.oF.ny) continue;
                            this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n9)) + this.oF.nx * n8] = 8;
                        }
                        continue;
                    }
                    for (n9 = n7 - 7; n9 < n7 - 1; ++n9) {
                        if (this.oF.ny - 1 - n9 < 0 || this.oF.ny - 1 - n9 >= this.oF.ny) continue;
                        this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n9)) + this.oF.nx * n8] = 12;
                    }
                    if (this.oF.ny - n7 < 0 || this.oF.ny - n7 >= this.oF.ny) continue;
                    this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - n7)) + this.oF.nx * n8] = 12;
                }
            }
            if (this.treeBox.isSelected()) {
                for (n3 = 0; n3 < 8; ++n3) {
                    this.oF.randomWood(12);
                }
            }
            if (this.cavesBox.isSelected()) {
                if (this.lavaBox.isSelected()) {
                    for (n3 = 0; n3 < 8; ++n3) {
                        this.oF.addSingleCave(1, 10, 30, 0.05);
                    }
                    for (n3 = 0; n3 < 3; ++n3) {
                        this.oF.addSingleVein(1, 10, 1000, 0.015, 1);
                    }
                }
                if (this.waterBox.isSelected()) {
                    for (n3 = 0; n3 < 8; ++n3) {
                        this.oF.addSingleCave(1, 8, 30, 0.05);
                    }
                    for (n3 = 0; n3 < 3; ++n3) {
                        this.oF.addSingleVein(1, 8, 1000, 0.015, 1);
                    }
                }
                for (n3 = 0; n3 < 12; ++n3) {
                    this.oF.addSingleCave(1, 0, 30, 0.05);
                }
                for (n3 = 0; n3 < 3; ++n3) {
                    this.oF.addSingleVein(1, 0, 500, 0.015, 1);
                }
                for (n3 = 0; n3 < 10; ++n3) {
                    this.oF.addSingleVein(1, 0, 300, 0.03, 1, 20);
                }
                for (n3 = 0; n3 < 12; ++n3) {
                    this.oF.addSingleCave(1, 16, 500, 0.03);
                }
                for (n3 = 0; n3 < 32; ++n3) {
                    this.oF.addSingleVein(1, 16, 200, 0.015, 1);
                }
                for (n3 = 0; n3 < 32; ++n3) {
                    this.oF.addSingleCave(1, 15, 500, 0.02);
                }
                for (n3 = 0; n3 < 8; ++n3) {
                    this.oF.addSingleVein(1, 15, 200, 0.015, 1);
                }
                for (n3 = 0; n3 < 20; ++n3) {
                    this.oF.addSingleCave(1, 14, 400, 0.0175);
                }
                for (n3 = 0; n3 < 8; ++n3) {
                    this.oF.addSingleVein(1, 14, 200, 0.015, 1);
                }
                for (n3 = 0; n3 < 20; ++n3) {
                    this.oF.addSingleCave(1, 56, 1000, 0.01564);
                }
                for (n3 = 0; n3 < this.oF.nx; ++n3) {
                    for (n8 = 0; n8 < this.oF.ny; ++n8) {
                        for (n7 = 0; n7 < this.oF.nz; ++n7) {
                            if (this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n8) + this.oF.nx * n7] != 21) continue;
                            this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n8) + this.oF.nx * n7] = 1;
                        }
                    }
                }
                this.oF.sealLiquids(1);
            }
        } else if (string == "Winter") {
            omenMap.SkyColor = new Color(153, 153, 255);
            omenMap.FogColor = new Color(214, 214, 255);
            this.grasslandMap(n6);
            for (n5 = 0; n5 < this.oF.map.blocks.length; ++n5) {
                if (omenMap.blocks[n5] != 18 && omenMap.blocks[n5] != 2) continue;
                omenMap.blocks[n5] = 36;
            }
            for (n5 = 0; n5 < this.oF.nx; ++n5) {
                for (n4 = 0; n4 < this.oF.nz; ++n4) {
                    if (this.oF.map.blocks[n5 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny + 1 - this.oF.ny / 2 - 1)) + this.oF.nx * n4] != 8) continue;
                    this.oF.map.blocks[n5 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny + 1 - this.oF.ny / 2 - 1)) + this.oF.nx * n4] = 20;
                }
            }
        } else if (string == "Hell") {
            int n10;
            int n11;
            omenMap.SkyColor = new Color(16, 4, 0);
            omenMap.CloudColor = new Color(33, 8, 0);
            omenMap.FogColor = new Color(16, 4, 0);
            omenMap.SkyBrightness = (byte)50;
            omenMap.SurroundingWaterType = (byte)10;
            double[][] dArray = this.makeTerrain(1, 1, (long)(2.147483647E9 * Math.random()));
            double d = dArray[0][0];
            double d3 = dArray[0][0];
            for (n3 = 0; n3 < this.smoothness.getValue(); ++n3) {
                dArray = this.smoothArray(dArray);
            }
            for (n3 = 0; n3 < dArray.length; ++n3) {
                for (n11 = 0; n11 < dArray.length; ++n11) {
                    d = d > dArray[n3][n11] ? d : dArray[n3][n11];
                    d3 = d3 < dArray[n3][n11] ? d3 : dArray[n3][n11];
                }
            }
            for (n3 = 0; n3 < dArray.length; ++n3) {
                for (n11 = 0; n11 < dArray.length; ++n11) {
                    dArray[n3][n11] = (dArray[n3][n11] - d3) / (d - d3) - 0.5;
                }
            }
            for (n3 = 0; n3 < this.oF.nx; ++n3) {
                for (n11 = 0; n11 < this.oF.nz; ++n11) {
                    int n12;
                    n10 = (int)((double)n6 + (double)n6 * dArray[n3][n11] * (0.04 * (double)this.heightScale.getValue()) + (double)(this.heightOffset.getValue() * this.oF.ny) / 20.0);
                    for (n12 = 0; n12 < n10 - 7; ++n12) {
                        if (this.oF.ny - 1 - n12 < 0 || this.oF.ny - 1 - n12 >= this.oF.ny) continue;
                        this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n12)) + this.oF.nx * n11] = 1;
                    }
                    if (this.lavaBox.isSelected() && n10 < this.oF.ny / 2) {
                        for (n12 = n10 - 7; n12 < n10 - 2; ++n12) {
                            if (this.oF.ny - 1 - n12 < 0 || this.oF.ny - 1 - n12 >= this.oF.ny) continue;
                            this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n12)) + this.oF.nx * n11] = 3;
                        }
                        for (n12 = n10 - 2; n12 < n10; ++n12) {
                            if (this.oF.ny - 1 - n12 < 0 || this.oF.ny - 1 - n12 >= this.oF.ny) continue;
                            this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n12)) + this.oF.nx * n11] = 3;
                        }
                        for (n12 = n10; n12 <= this.oF.ny / 2 - 1; ++n12) {
                            if (this.oF.ny - 1 - n12 < 0 || this.oF.ny - 1 - n12 >= this.oF.ny) continue;
                            this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n12)) + this.oF.nx * n11] = 10;
                        }
                        continue;
                    }
                    for (n12 = n10 - 7; n12 < n10 - 1; ++n12) {
                        if (this.oF.ny - 1 - n12 < 0 || this.oF.ny - 1 - n12 >= this.oF.ny) continue;
                        this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n12)) + this.oF.nx * n11] = 3;
                    }
                    if (this.oF.ny - n10 < 0 || this.oF.ny - n10 >= this.oF.ny) continue;
                    this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - n10)) + this.oF.nx * n11] = 3;
                }
            }
            if (this.cavesBox.isSelected()) {
                if (this.lavaBox.isSelected()) {
                    for (n3 = 0; n3 < 8; ++n3) {
                        this.oF.addSingleCave(1, 10, 30, 0.05);
                    }
                    for (n3 = 0; n3 < 3; ++n3) {
                        this.oF.addSingleVein(1, 10, 1000, 0.015, 1);
                    }
                }
                if (this.waterBox.isSelected()) {
                    for (n3 = 0; n3 < 8; ++n3) {
                        this.oF.addSingleCave(1, 8, 30, 0.05);
                    }
                    for (n3 = 0; n3 < 3; ++n3) {
                        this.oF.addSingleVein(1, 8, 1000, 0.015, 1);
                    }
                }
                for (n3 = 0; n3 < 12; ++n3) {
                    this.oF.addSingleCave(1, 0, 30, 0.05);
                }
                for (n3 = 0; n3 < 3; ++n3) {
                    this.oF.addSingleVein(1, 0, 500, 0.015, 1);
                }
                for (n3 = 0; n3 < 10; ++n3) {
                    this.oF.addSingleVein(1, 0, 300, 0.03, 1, 20);
                }
                for (n3 = 0; n3 < 12; ++n3) {
                    this.oF.addSingleCave(1, 16, 500, 0.03);
                }
                for (n3 = 0; n3 < 32; ++n3) {
                    this.oF.addSingleVein(1, 16, 200, 0.015, 1);
                }
                for (n3 = 0; n3 < 32; ++n3) {
                    this.oF.addSingleCave(1, 15, 500, 0.02);
                }
                for (n3 = 0; n3 < 8; ++n3) {
                    this.oF.addSingleVein(1, 15, 200, 0.015, 1);
                }
                for (n3 = 0; n3 < 20; ++n3) {
                    this.oF.addSingleCave(1, 14, 400, 0.0175);
                }
                for (n3 = 0; n3 < 8; ++n3) {
                    this.oF.addSingleVein(1, 14, 200, 0.015, 1);
                }
                for (n3 = 0; n3 < 20; ++n3) {
                    this.oF.addSingleCave(1, 56, 1000, 0.01564);
                }
                for (n3 = 0; n3 < this.oF.nx; ++n3) {
                    for (n11 = 0; n11 < this.oF.ny; ++n11) {
                        for (n10 = 0; n10 < this.oF.nz; ++n10) {
                            if (this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n11) + this.oF.nx * n10] != 21) continue;
                            this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n11) + this.oF.nx * n10] = 1;
                        }
                    }
                }
                this.oF.sealLiquids(1);
            }
        } else if (string == "Mountain") {
            int n13;
            int n14;
            double[][] dArray = this.makeTerrain(1, 1, (long)(2.147483647E9 * Math.random()));
            double[][] dArray2 = this.makeTerrain(1, 1, (long)(2.147483647E9 * Math.random()));
            double d = dArray[0][0];
            double d4 = dArray[0][0];
            double d5 = dArray2[0][0];
            double d6 = dArray2[0][0];
            for (n2 = 0; n2 < this.smoothness.getValue(); ++n2) {
                dArray = this.smoothArray(dArray);
            }
            for (n2 = 0; n2 < 10 + this.smoothness.getValue(); ++n2) {
                dArray2 = this.smoothArray(dArray2);
            }
            for (n2 = 0; n2 < dArray.length; ++n2) {
                for (n = 0; n < dArray.length; ++n) {
                    d = d > dArray[n2][n] ? d : dArray[n2][n];
                    d4 = d4 < dArray[n2][n] ? d4 : dArray[n2][n];
                    d5 = d5 > dArray2[n2][n] ? d5 : dArray2[n2][n];
                    d6 = d6 < dArray2[n2][n] ? d6 : dArray2[n2][n];
                }
            }
            for (n2 = 0; n2 < dArray.length; ++n2) {
                for (n = 0; n < dArray.length; ++n) {
                    dArray[n2][n] = (dArray[n2][n] - d4) / (d - d4) - 0.5;
                }
            }
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                for (n = 0; n < dArray2.length; ++n) {
                    dArray2[n2][n] = (dArray2[n2][n] - d6) / (d5 - d6) - 0.5;
                }
            }
            for (n2 = 0; n2 < this.oF.nx; ++n2) {
                for (n = 0; n < this.oF.nz; ++n) {
                    n14 = (int)((double)n6 + (double)n6 * dArray[n2][n] * (0.004 * (double)this.heightScale.getValue()));
                    for (n13 = 0; n13 < n14 - 7; ++n13) {
                        if (this.oF.ny - 1 - n13 < 0 || this.oF.ny - 1 - n13 >= this.oF.ny) continue;
                        this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n13)) + this.oF.nx * n] = 1;
                    }
                    if (this.waterBox.isSelected() && n14 < this.oF.ny / 2) {
                        for (n13 = n14 - 7; n13 < n14 - 2; ++n13) {
                            if (this.oF.ny - 1 - n13 < 0 || this.oF.ny - 1 - n13 >= this.oF.ny) continue;
                            this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n13)) + this.oF.nx * n] = 3;
                        }
                        for (n13 = n14 - 2; n13 < n14; ++n13) {
                            if (this.oF.ny - 1 - n13 < 0 || this.oF.ny - 1 - n13 >= this.oF.ny) continue;
                            this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n13)) + this.oF.nx * n] = 12;
                        }
                        for (n13 = n14; n13 <= this.oF.ny / 2 - 1; ++n13) {
                            if (this.oF.ny - 1 - n13 < 0 || this.oF.ny - 1 - n13 >= this.oF.ny) continue;
                            this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n13)) + this.oF.nx * n] = 8;
                        }
                        continue;
                    }
                    for (n13 = n14 - 7; n13 < n14 - 1; ++n13) {
                        if (this.oF.ny - 1 - n13 < 0 || this.oF.ny - 1 - n13 >= this.oF.ny) continue;
                        this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n13)) + this.oF.nx * n] = 3;
                    }
                    if (this.oF.ny - n14 < 0 || this.oF.ny - n14 >= this.oF.ny) continue;
                    this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - n14)) + this.oF.nx * n] = 2;
                }
            }
            for (n2 = 0; n2 < this.oF.nx; ++n2) {
                for (n = 0; n < this.oF.nz; ++n) {
                    n14 = (int)((double)n6 + (double)n6 * dArray2[n2][n] * (0.06 * (double)this.heightScale.getValue()));
                    if (n14 <= (int)((double)n6 + (double)n6 * dArray[n2][n] * (0.004 * (double)this.heightScale.getValue()))) continue;
                    n14 = (int)((double)n14 + (double)(this.heightOffset.getValue() * this.oF.ny) / 20.0);
                    for (n13 = 0; n13 < n14 - 7; ++n13) {
                        if (this.oF.ny - 1 - n13 < 0 || this.oF.ny - 1 - n13 >= this.oF.ny) continue;
                        this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n13)) + this.oF.nx * n] = 1;
                    }
                    if (this.waterBox.isSelected() && n14 < this.oF.ny / 2) {
                        for (n13 = n14 - 7; n13 < n14 - 2; ++n13) {
                            if (this.oF.ny - 1 - n13 < 0 || this.oF.ny - 1 - n13 >= this.oF.ny) continue;
                            this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n13)) + this.oF.nx * n] = 21;
                        }
                        for (n13 = n14 - 2; n13 < n14; ++n13) {
                            if (this.oF.ny - 1 - n13 < 0 || this.oF.ny - 1 - n13 >= this.oF.ny) continue;
                            this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n13)) + this.oF.nx * n] = 13;
                        }
                        for (n13 = n14; n13 <= this.oF.ny / 2 - 1; ++n13) {
                            if (this.oF.ny - 1 - n13 < 0 || this.oF.ny - 1 - n13 >= this.oF.ny) continue;
                            this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n13)) + this.oF.nx * n] = 8;
                        }
                        continue;
                    }
                    for (n13 = n14 - 7; n13 < n14 - 1; ++n13) {
                        if (this.oF.ny - 1 - n13 < 0 || this.oF.ny - 1 - n13 >= this.oF.ny) continue;
                        this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n13)) + this.oF.nx * n] = 21;
                    }
                    if (this.oF.ny - n14 < 0 || this.oF.ny - n14 >= this.oF.ny || !((double)n14 > (0.85 + 0.4 * dArray[n2][n]) * (double)this.oF.ny)) continue;
                    this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - n14)) + this.oF.nx * n] = 36;
                }
            }
            for (n2 = 0; n2 < this.oF.ny; ++n2) {
                this.spreadType(n2, 12, 0.8);
            }
            for (n2 = 0; n2 < this.oF.ny; ++n2) {
                this.spreadType(n2, 12, 0.7);
            }
            for (n2 = 0; n2 < this.oF.ny; ++n2) {
                this.spreadType(n2, 12, 0.5);
            }
            this.removeTop(12);
            if (this.treeBox.isSelected()) {
                for (n2 = 0; n2 < 8; ++n2) {
                    this.oF.randomWood(2);
                }
            }
            for (n2 = 0; n2 < 6; ++n2) {
                this.oF.randomPlants(38, 2, (int)(2.0 + 13.0 * Math.random()));
            }
            for (n2 = 0; n2 < 6; ++n2) {
                this.oF.randomPlants(37, 2, (int)(2.0 + 13.0 * Math.random()));
            }
            for (n2 = 0; n2 < 3; ++n2) {
                this.oF.randomPlants(40, 1, (int)(2.0 + 13.0 * Math.random()));
            }
            for (n2 = 0; n2 < 3; ++n2) {
                this.oF.randomPlants(39, 1, (int)(2.0 + 13.0 * Math.random()));
            }
            for (n2 = 0; n2 < 3; ++n2) {
                this.oF.randomPlants(6, 2, (int)(5.0 + 13.0 * Math.random()));
            }
            if (this.cavesBox.isSelected()) {
                if (this.lavaBox.isSelected()) {
                    for (n2 = 0; n2 < 8; ++n2) {
                        this.oF.addSingleCave(1, 10, 30, 0.05);
                    }
                    for (n2 = 0; n2 < 3; ++n2) {
                        this.oF.addSingleVein(1, 10, 1000, 0.015, 1);
                    }
                }
                if (this.waterBox.isSelected()) {
                    for (n2 = 0; n2 < 8; ++n2) {
                        this.oF.addSingleCave(1, 8, 30, 0.05);
                    }
                    for (n2 = 0; n2 < 3; ++n2) {
                        this.oF.addSingleVein(1, 8, 1000, 0.015, 1);
                    }
                }
                for (n2 = 0; n2 < 12; ++n2) {
                    this.oF.addSingleCave(1, 0, 30, 0.05);
                }
                for (n2 = 0; n2 < 3; ++n2) {
                    this.oF.addSingleVein(1, 0, 500, 0.015, 1);
                }
                for (n2 = 0; n2 < 10; ++n2) {
                    this.oF.addSingleVein(1, 0, 300, 0.03, 1, 20);
                }
                for (n2 = 0; n2 < 12; ++n2) {
                    this.oF.addSingleCave(1, 16, 500, 0.03);
                }
                for (n2 = 0; n2 < 32; ++n2) {
                    this.oF.addSingleVein(1, 16, 200, 0.015, 1);
                }
                for (n2 = 0; n2 < 32; ++n2) {
                    this.oF.addSingleCave(1, 15, 500, 0.02);
                }
                for (n2 = 0; n2 < 8; ++n2) {
                    this.oF.addSingleVein(1, 15, 200, 0.015, 1);
                }
                for (n2 = 0; n2 < 20; ++n2) {
                    this.oF.addSingleCave(1, 14, 400, 0.0175);
                }
                for (n2 = 0; n2 < 8; ++n2) {
                    this.oF.addSingleVein(1, 14, 200, 0.015, 1);
                }
                for (n2 = 0; n2 < 20; ++n2) {
                    this.oF.addSingleCave(1, 56, 1000, 0.01564);
                }
                for (n2 = 0; n2 < this.oF.nx; ++n2) {
                    for (n = 0; n < this.oF.ny; ++n) {
                        for (n14 = 0; n14 < this.oF.nz; ++n14) {
                            if (this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n) + this.oF.nx * n14] != 21) continue;
                            this.oF.map.blocks[n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n) + this.oF.nx * n14] = 1;
                        }
                    }
                }
                this.oF.sealLiquids(1);
            }
        } else if (string == "Caverns") {
            int n15;
            int n16;
            int n17;
            omenMap.FogColor = Color.black;
            omenMap.SkyColor = new Color(0, 20, 64);
            for (n5 = 0; n5 < this.oF.map.blocks.length; ++n5) {
                this.oF.map.blocks[n5] = 1;
            }
            this.setLayer(0, 7);
            this.setLayer(this.oF.ny - 1, 7);
            for (n5 = 0; n5 < this.oF.ny; ++n5) {
                for (n4 = 0; n4 < this.oF.nx; ++n4) {
                    this.oF.map.blocks[n4 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n5)) + this.oF.nx * 0] = 7;
                    this.oF.map.blocks[n4 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n5)) + this.oF.nx * (this.oF.nz - 1)] = 7;
                }
                for (n4 = 0; n4 < this.oF.nz; ++n4) {
                    this.oF.map.blocks[0 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n5)) + this.oF.nx * n4] = 7;
                    this.oF.map.blocks[this.oF.nx - 1 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n5)) + this.oF.nx * n4] = 7;
                }
            }
            int n18 = (this.oF.nx > this.oF.ny ? this.oF.ny : this.oF.nx) < this.oF.nz ? (this.oF.nx > this.oF.ny ? this.oF.ny : this.oF.nx) : (n5 = this.oF.nz);
            if (n5 > 64) {
                n5 = 64;
            }
            n4 = 10;
            int n19 = n17 / 2;
            int n20 = 8 * (omenMap.blocks.length / (n5 * n5 * n5));
            for (n17 = n5 - n4; n17 > 1; n17 /= 2) {
                n19 = n17 / 2;
                for (n3 = 0; n3 < n20; ++n3) {
                    n16 = (int)(Math.random() * (double)(this.oF.nx - n17 / 2 - n4)) + n4 / 2;
                    n15 = (int)(Math.random() * (double)(this.oF.ny - n17 - n4)) + n4 / 2;
                    int n21 = (int)(Math.random() * (double)(this.oF.nz - n17 / 2 - n4)) + n4 / 2;
                    for (int i = 0; i < n17 / 2; ++i) {
                        for (n2 = 0; n2 < n17; ++n2) {
                            for (n = 0; n < n17 / 2; ++n) {
                                if ((2 * i - n19) * (2 * i - n19) + (n2 - n19) * (n2 - n19) + (2 * n - n19) * (2 * n - n19) >= n19 * n19 || n16 + i >= this.oF.nx || n15 + n2 >= this.oF.ny || n21 + n >= this.oF.nz || n16 + i < 0 || n15 + n2 < 0 || n21 + n < 0) continue;
                                this.oF.map.blocks[n16 + i + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (n15 + n2)) + this.oF.nx * (n21 + n)] = 0;
                            }
                        }
                    }
                }
                n20 *= 4;
            }
            for (n3 = 0; n3 < this.smoothness.getValue() + 1; ++n3) {
                this.oF.smoothLayer3d();
            }
            for (n3 = 0; n3 < this.oF.nx; ++n3) {
                for (n16 = 0; n16 < 7 * this.oF.ny / 8; ++n16) {
                    for (n15 = 0; n15 < this.oF.nz; ++n15) {
                        if (this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n16) + this.oF.nx * n15] != 1) continue;
                        this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n16) + this.oF.nx * n15] = 21;
                    }
                }
            }
            if (this.lavaBox.isSelected()) {
                for (n3 = 0; n3 < 8; ++n3) {
                    this.oF.addSingleCave(1, 10, 30, 0.05);
                }
            }
            for (n3 = 0; n3 < this.oF.nx; ++n3) {
                for (n16 = 3 * this.oF.ny / 4; n16 < 7 * this.oF.ny / 8; ++n16) {
                    for (n15 = 0; n15 < this.oF.nz; ++n15) {
                        if (this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n16) + this.oF.nx * n15] != 21) continue;
                        this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n16) + this.oF.nx * n15] = 1;
                    }
                }
            }
            if (this.waterBox.isSelected()) {
                for (n3 = 0; n3 < 8; ++n3) {
                    this.oF.addSingleCave(1, 8, 30, 0.05);
                }
            }
            if (this.treeBox.isSelected()) {
                for (n3 = 0; n3 < 8; ++n3) {
                    this.setLayer(this.oF.ny - 1 - n3, 0);
                }
                this.setLayer(this.oF.ny - 1 - 8, 2);
                this.setLayer(this.oF.ny - 1 - 9, 3);
                for (n3 = 0; n3 < 4; ++n3) {
                    this.oF.randomWood(2);
                }
                for (n3 = 0; n3 < 6; ++n3) {
                    this.oF.randomPlants(38, 2, (int)(2.0 + 13.0 * Math.random()));
                }
                for (n3 = 0; n3 < 6; ++n3) {
                    this.oF.randomPlants(37, 2, (int)(2.0 + 13.0 * Math.random()));
                }
            }
            for (n3 = 0; n3 < this.oF.nx; ++n3) {
                for (n16 = 0; n16 < 7 * this.oF.ny / 8; ++n16) {
                    for (n15 = 0; n15 < this.oF.nz; ++n15) {
                        if (this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n16) + this.oF.nx * n15] != 21) continue;
                        this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n16) + this.oF.nx * n15] = 1;
                    }
                }
            }
            for (n3 = 0; n3 < 8; ++n3) {
                this.oF.addSingleCave(1, 0, 30, 0.05);
            }
            for (n3 = 0; n3 < 8; ++n3) {
                this.oF.addSingleCave(1, 16, 500, 0.03);
            }
            for (n3 = 0; n3 < 16; ++n3) {
                this.oF.addSingleCave(1, 13, 500, 0.03);
            }
            for (n3 = 0; n3 < 16; ++n3) {
                this.oF.addSingleCave(1, 35, 500, 0.03);
            }
            for (n3 = 0; n3 < 16; ++n3) {
                this.oF.addSingleCave(1, 4, 500, 0.03);
            }
            for (n3 = 0; n3 < 16; ++n3) {
                this.oF.addSingleCave(1, 14, 500, 0.02);
            }
            for (n3 = 0; n3 < 32; ++n3) {
                this.oF.addSingleCave(1, 15, 500, 0.02);
            }
            for (n3 = 0; n3 < 32; ++n3) {
                this.oF.addSingleVein(1, 16, 200, 0.015, 1);
            }
            for (n3 = 0; n3 < 8; ++n3) {
                this.oF.addSingleVein(1, 14, 200, 0.015, 1);
            }
            for (n3 = 0; n3 < 8; ++n3) {
                this.oF.addSingleVein(1, 15, 200, 0.015, 1);
            }
            for (n3 = 0; n3 < 3; ++n3) {
                this.oF.addSingleVein(1, 0, 500, 0.015, 1);
            }
            for (n3 = 0; n3 < 20; ++n3) {
                this.oF.addSingleCave(1, 56, 1000, 0.01564);
            }
            this.oF.sealLiquids(7);
        } else if (string == "Ruins") {
            int n22;
            double[][] dArray = this.makeTerrain(1, 1, (long)(2.147483647E9 * Math.random()));
            double d = dArray[0][0];
            double d7 = dArray[0][0];
            for (n3 = 0; n3 < this.smoothness.getValue(); ++n3) {
                dArray = this.smoothArray(dArray);
            }
            for (n3 = 0; n3 < dArray.length; ++n3) {
                for (n22 = 0; n22 < dArray.length; ++n22) {
                    d = d > dArray[n3][n22] ? d : dArray[n3][n22];
                    d7 = d7 < dArray[n3][n22] ? d7 : dArray[n3][n22];
                }
            }
            for (n3 = 0; n3 < dArray.length; ++n3) {
                for (n22 = 0; n22 < dArray.length; ++n22) {
                    dArray[n3][n22] = (dArray[n3][n22] - d7) / (d - d7) - 0.5;
                }
            }
            for (n3 = 0; n3 < this.oF.nx; ++n3) {
                for (n22 = 0; n22 < this.oF.nz; ++n22) {
                    int n23;
                    int n24 = (int)((double)n6 + (double)n6 * dArray[n3][n22] * (0.04 * (double)this.heightScale.getValue()) + (double)(this.heightOffset.getValue() * this.oF.ny) / 20.0);
                    for (n23 = 0; n23 < n24 - 7; ++n23) {
                        if (this.oF.ny - 1 - n23 < 0 || this.oF.ny - 1 - n23 >= this.oF.ny) continue;
                        this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n23)) + this.oF.nx * n22] = 1;
                    }
                    if (this.waterBox.isSelected() && n24 < this.oF.ny / 2) {
                        for (n23 = n24 - 7; n23 < n24 - 2; ++n23) {
                            if (this.oF.ny - 1 - n23 < 0 || this.oF.ny - 1 - n23 >= this.oF.ny) continue;
                            this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n23)) + this.oF.nx * n22] = 3;
                        }
                        for (n23 = n24 - 2; n23 < n24; ++n23) {
                            if (this.oF.ny - 1 - n23 < 0 || this.oF.ny - 1 - n23 >= this.oF.ny) continue;
                            this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n23)) + this.oF.nx * n22] = 13;
                        }
                        for (n23 = n24; n23 < this.oF.ny / 2; ++n23) {
                            if (this.oF.ny - 1 - n23 < 0 || this.oF.ny - 1 - n23 >= this.oF.ny) continue;
                            this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n23)) + this.oF.nx * n22] = 8;
                        }
                        continue;
                    }
                    for (n23 = n24 - 7; n23 < n24 - 1; ++n23) {
                        if (this.oF.ny - 1 - n23 < 0 || this.oF.ny - 1 - n23 >= this.oF.ny) continue;
                        this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - n23)) + this.oF.nx * n22] = 3;
                    }
                    if (this.oF.ny - n24 < 0 || this.oF.ny - n24 >= this.oF.ny) continue;
                    this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - n24)) + this.oF.nx * n22] = 2;
                }
            }
            if (!this.waterBox.isSelected()) {
                for (n3 = 0; n3 < n6 - 7; ++n3) {
                    this.setLayer(n3, 1);
                }
                for (n3 = n6 - 7; n3 < n6 - 1; ++n3) {
                    this.setLayer(n3, 3);
                }
                for (n3 = n6 - 1; n3 < n6; ++n3) {
                    this.setLayer(n3, 2);
                }
                for (n3 = 0; n3 < this.oF.nx; ++n3) {
                    for (n22 = 0; n22 < this.oF.nz; ++n22) {
                        if (this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (n6 - 1)) + this.oF.nx * n22] != 3) continue;
                        this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n6) + this.oF.nx * n22] = 3;
                    }
                }
            }
            if (this.treeBox.isSelected()) {
                for (n3 = 0; n3 < 4; ++n3) {
                    this.oF.randomWood(2);
                }
            }
            for (n3 = 0; n3 < 7; ++n3) {
                this.oF.randomPlants(38, 2, (int)(2.0 + 30.0 * Math.random()));
            }
            for (n3 = 0; n3 < 7; ++n3) {
                this.oF.randomPlants(37, 2, (int)(2.0 + 30.0 * Math.random()));
            }
            for (n3 = 0; n3 < this.oF.nx / 8; ++n3) {
                for (n22 = 0; n22 < this.oF.nz / 8; ++n22) {
                    double d8 = Math.sqrt((double)((n3 * 8 - this.oF.nx / 2) * (n3 * 8 - this.oF.nx / 2) + (n22 * 8 - this.oF.nz / 2) * (n22 * 8 - this.oF.nz / 2)) / (double)(this.oF.nx / 2 * (this.oF.nx / 2) + this.oF.nz / 2 * (this.oF.nz / 2)));
                    if (!(0.5 * Math.random() > d8)) continue;
                    if (Math.random() < 0.92) {
                        this.oF.randomRuin(8 * n3, this.oF.ny / 2, 8 * n22, 3 + (int)(Math.random() * ((double)this.oF.nx / 16.0)), 3 + (int)(Math.random() * ((double)this.oF.ny / 64.0) * Math.pow((1.0 - d8) * 1.9, 6.0)), 3 + (int)(Math.random() * ((double)this.oF.nx / 16.0)));
                        continue;
                    }
                    if (Math.random() < 0.5) {
                        this.oF.randomTower(8 * n3, this.oF.ny / 2, 8 * n22, 3 + (int)((double)this.oF.nx / 48.0 * Math.random()), 8 + (int)(Math.random() * ((double)this.oF.ny / 64.0) * Math.pow((1.0 - d8) * 1.8, 6.0)));
                        continue;
                    }
                    this.oF.randomStairs(8 * n3, this.oF.ny / 2, 8 * n22, 8 + (int)(Math.random() * ((double)this.oF.ny / 64.0) * Math.pow((1.0 - d8) * 1.8, 6.0)));
                }
            }
            if (this.waterBox.isSelected()) {
                for (n3 = 0; n3 < this.oF.nx; ++n3) {
                    for (n22 = 0; n22 < this.oF.nz; ++n22) {
                        if (this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (n6 - 1)) + this.oF.nx * n22] != 4 && this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (n6 - 1)) + this.oF.nx * n22] != 48) continue;
                        for (int i = n6; this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - i) + this.oF.nx * n22] == 8 && i < this.oF.ny - 1; ++i) {
                            this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - i) + this.oF.nx * n22] = 48;
                        }
                    }
                }
            }
            if (this.cavesBox.isSelected()) {
                n3 = this.oF.typeNo;
                this.oF.typeNo = 1;
                this.oF.quickCaves();
                this.oF.typeNo = (byte)n3;
            }
        }
        if (this.floodBarrier.isSelected()) {
            for (int i = 0; i < this.oF.ny / 2; ++i) {
                int n25;
                for (n25 = 0; n25 < this.oF.nx; ++n25) {
                    this.oF.map.blocks[n25 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - i)) + this.oF.nx * 0] = 7;
                    this.oF.map.blocks[n25 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - i)) + this.oF.nx * (this.oF.nz - 1)] = 7;
                }
                for (n25 = 0; n25 < this.oF.nz; ++n25) {
                    this.oF.map.blocks[0 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - i)) + this.oF.nx * n25] = 7;
                    this.oF.map.blocks[this.oF.nx - 1 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - (this.oF.ny - 1 - i)) + this.oF.nx * n25] = 7;
                }
            }
        }
        this.oF.println("Generated map in " + 0.001 * (double)(System.currentTimeMillis() - l) + " seconds");
        this.oF.vx = 0;
        this.oF.vy = 0;
        this.oF.vz = 0;
        this.oF.currentView = 1;
        this.oF.updateInfoFields();
        this.oF.updateEnvironmentFields();
        this.oF.mapFile = null;
        this.oF.fastDraw = false;
        this.oF.repaint();
    }

    public NewMapBox(Omen omen) {
        JComponent jComponent;
        this.oF = omen;
        this.setSize(800, 400);
        this.setDefaultCloseOperation(2);
        String[] stringArray = new String[]{"Name: ", "Author: ", "Width (X): ", "Depth (Y): ", "Height (Z): ", "Spawn point X : ", "Spawn point Y: ", "Spawn point Z : ", "Spawn Angle"};
        String[] stringArray2 = new String[]{"A Nice World", "--", "256", "64", "256", "128", "40", "128", "0"};
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.mapTypeGroup = new ButtonGroup();
        this.blankRB = new JRadioButton("Blank Map");
        this.flatRB = new JRadioButton("Flat Map");
        this.randomRB = new JRadioButton("Random Map");
        this.lavaBox = new JCheckBox("Lava");
        this.waterBox = new JCheckBox("Water");
        this.treeBox = new JCheckBox("Trees");
        this.cavesBox = new JCheckBox("Caves");
        this.lavaBox.setSelected(true);
        this.waterBox.setSelected(true);
        this.treeBox.setSelected(true);
        this.cavesBox.setSelected(true);
        this.heightScaleLabel = new JLabel("Height Scale (15)");
        this.groundHeightLabel = new JLabel("Ground Height (0)");
        this.smoothnessLabel = new JLabel("Smoothness (3)");
        this.heightScale = new JSlider(1, 100, 15);
        this.heightScale.setMajorTickSpacing(10);
        this.heightScale.setPaintTicks(true);
        this.heightOffset = new JSlider(-10, 10, 0);
        this.heightOffset.setMajorTickSpacing(1);
        this.heightOffset.setSnapToTicks(true);
        this.heightOffset.setPaintTicks(true);
        this.smoothness = new JSlider(0, 29, 3);
        this.smoothness.setMajorTickSpacing(3);
        this.smoothness.setSnapToTicks(true);
        this.smoothness.setPaintTicks(true);
        this.presetIcons = new ImageIcon[1 + this.flatPresets.length + this.randomPresets.length];
        for (int i = 0; i < this.presetIcons.length; ++i) {
            this.presetIcons[i] = new ImageIcon(this.getClass().getResource("/icons/newmap/" + i + ".png"));
        }
        this.previewLabel = new JLabel(this.presetIcons[0], 0);
        this.previewLabel.setOpaque(true);
        this.previewLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.flatList = new JComboBox<String>(this.flatPresets);
        this.randomList = new JComboBox<String>(this.randomPresets);
        this.floodBarrier = new JCheckBox("Add Flood Barrier");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1)));
        JPanel jPanel5 = new JPanel(new GridLayout(6, 2));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1)));
        this.mapTypeGroup.add(this.blankRB);
        this.mapTypeGroup.add(this.flatRB);
        this.mapTypeGroup.add(this.randomRB);
        jPanel3.add(this.blankRB);
        jPanel4.add(this.flatRB);
        jPanel4.add(this.flatList);
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.99;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.weighty = 0.6;
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.gridy = 3;
        jPanel2.add((Component)this.floodBarrier, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.weightx = 0.01;
        jPanel2.add((Component)this.previewLabel, gridBagConstraints);
        jPanel5.add(this.randomRB);
        jPanel5.add(this.randomList);
        jPanel5.add(this.heightScaleLabel);
        jPanel5.add(this.heightScale);
        jPanel5.add(this.groundHeightLabel);
        jPanel5.add(this.heightOffset);
        jPanel5.add(this.smoothnessLabel);
        jPanel5.add(this.smoothness);
        jPanel5.add(this.lavaBox);
        jPanel5.add(this.waterBox);
        jPanel5.add(this.treeBox);
        jPanel5.add(this.cavesBox);
        JComponent jComponent2 = (JComponent)this.getContentPane();
        jComponent2.setLayout(new GridLayout(1, 2));
        jComponent2.add(jPanel);
        jComponent2.add(jPanel2);
        this.textFields = new JTextField[stringArray.length];
        jPanel.setLayout(new GridLayout(10, 2));
        for (int i = 0; i < stringArray.length; ++i) {
            jComponent = new JLabel(stringArray[i]);
            this.textFields[i] = new JTextField(stringArray2[i], 30);
            jPanel.add(jComponent);
            ((JLabel)jComponent).setLabelFor(this.textFields[i]);
            jPanel.add(this.textFields[i]);
        }
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewMapBox.this.makeNewMap();
                NewMapBox.this.dispose();
            }
        });
        jComponent = new JButton("Cancel");
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewMapBox.this.dispose();
            }
        });
        jPanel.add(jButton);
        jPanel.add(jComponent);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jComponent2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.blankRB.addActionListener(this);
        this.flatRB.addActionListener(this);
        this.randomRB.addActionListener(this);
        this.randomList.addActionListener(this);
        this.lavaBox.addActionListener(this);
        this.waterBox.addActionListener(this);
        this.heightOffset.addChangeListener(this);
        this.smoothness.addChangeListener(this);
        this.heightScale.addChangeListener(this);
        this.flatList.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.blankRB) {
            this.previewLabel.setIcon(this.presetIcons[0]);
        } else if (object == this.flatRB) {
            this.previewLabel.setIcon(this.presetIcons[1 + this.flatList.getSelectedIndex()]);
        } else if (object == this.randomRB) {
            this.previewLabel.setIcon(this.presetIcons[1 + this.flatPresets.length + this.randomList.getSelectedIndex()]);
        } else if (object == this.flatList) {
            this.flatRB.setSelected(true);
            this.previewLabel.setIcon(this.presetIcons[1 + this.flatList.getSelectedIndex()]);
        } else if (object == this.randomList || object == this.waterBox || object == this.lavaBox) {
            this.randomRB.setSelected(true);
            this.previewLabel.setIcon(this.presetIcons[1 + this.flatPresets.length + this.randomList.getSelectedIndex()]);
        }
        this.previewLabel.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.randomRB.setSelected(true);
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = jSlider.getValue();
        if (jSlider == this.smoothness) {
            this.smoothnessLabel.setText("Smoothness (" + n + ")");
        } else if (jSlider == this.heightOffset) {
            this.groundHeightLabel.setText("Ground Height (" + n + ")");
        } else if (jSlider == this.heightScale) {
            this.heightScaleLabel.setText("Height Scale (" + n + ")");
        }
    }
}

