/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforums.osici;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import net.minecraftforums.osici.Omen;

class MapPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    Omen oF;
    Image[] tiles;

    public MapPanel(Omen omen) {
        this.oF = omen;
        this.setSize(omen.nx * omen.scale, omen.nz * omen.scale);
        this.setPreferredSize(new Dimension(omen.nx * omen.scale, omen.nz * omen.scale));
        this.setBackground(Color.black);
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.tiles = new Image[omen.typeIcons.length];
        for (int i = 0; i < this.tiles.length; ++i) {
            this.tiles[i] = omen.typeIcons[i].getImage();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n = 0;
        float f = 0.0f;
        boolean bl = false;
        if (!System.getProperty("os.name").equals("Mac OS X")) {
            this.oF.fastDraw = false;
        }
        if (this.oF.currentView == 1) {
            int n2;
            int n3;
            if (this.oF.Overview) {
                n3 = this.oF.alwaysShowAll ? 0 : this.oF.vy;
                graphics.clearRect(0, 0, this.oF.screenSizeX, this.oF.screenSizeY);
                for (n2 = 0; n2 < this.oF.nx; ++n2) {
                    for (int i = 0; i < this.oF.nz; ++i) {
                        int n4 = 0;
                        bl = false;
                        int n5 = n3;
                        while (n5 < this.oF.ny) {
                            n = n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n5) + this.oF.nx * i;
                            n4 = n5++;
                            if (this.oF.map.blocks[n] == 0) continue;
                            bl = true;
                            break;
                        }
                        f = 1.0f - (float)(n4 - n3) * 1.0f / (float)(this.oF.ny - n3);
                        if (this.oF.scale < 16 || this.oF.hideTextures) {
                            try {
                                switch (this.oF.overviewType) {
                                    case 0: {
                                        graphics.setColor(new Color((int)(f * (float)this.oF.bColors[this.oF.map.blocks[n]].getRed()), (int)(f * (float)this.oF.bColors[this.oF.map.blocks[n]].getGreen()), (int)(f * (float)this.oF.bColors[this.oF.map.blocks[n]].getBlue())));
                                        break;
                                    }
                                    case 1: {
                                        graphics.setColor(new Color(f, f, f));
                                        break;
                                    }
                                    case 2: {
                                        graphics.setColor(new Color(Color.HSBtoRGB(f, 1.0f, 1.0f)));
                                    }
                                }
                            }
                            catch (Exception exception) {
                                this.oF.println("Color out of bounds: " + n4 + " " + n3 + " " + f);
                            }
                            if (!bl) continue;
                            graphics.fillRect(n2 * this.oF.scale, i * this.oF.scale, this.oF.scale, this.oF.scale);
                            continue;
                        }
                        try {
                            graphics.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f - 0.5f * f));
                        }
                        catch (Exception exception) {
                            this.oF.println("Color out of bounds: " + n4 + " " + n3 + " " + f);
                        }
                        if (!bl) continue;
                        graphics.drawImage(this.tiles[this.oF.map.blocks[n]], n2 * this.oF.scale, i * this.oF.scale, this.oF.scale, this.oF.scale, this);
                        graphics.fillRect(n2 * this.oF.scale, i * this.oF.scale, this.oF.scale, this.oF.scale);
                    }
                }
            } else if (this.oF.fastDraw) {
                for (n3 = 0; n3 < this.oF.nx; ++n3) {
                    for (n2 = 0; n2 < this.oF.nz; ++n2) {
                        if (!this.oF.changed[n3 + this.oF.nx * n2 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - this.oF.vy)]) continue;
                        if (this.oF.scale < 16) {
                            graphics.setColor(this.oF.bColors[this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - this.oF.vy) + this.oF.nx * n2]]);
                            graphics.fillRect(n3 * this.oF.scale, n2 * this.oF.scale, this.oF.scale, this.oF.scale);
                        } else {
                            graphics.drawImage(this.tiles[this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - this.oF.vy) + this.oF.nx * n2]], n3 * this.oF.scale, n2 * this.oF.scale, this.oF.scale, this.oF.scale, this);
                        }
                        this.oF.changed[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - this.oF.vy) + this.oF.nx * n2] = false;
                    }
                }
            } else {
                graphics.clearRect(0, 0, this.oF.screenSizeX, this.oF.screenSizeY);
                for (n3 = 0; n3 < this.oF.nx; ++n3) {
                    for (n2 = 0; n2 < this.oF.nz; ++n2) {
                        if (this.oF.scale < 16) {
                            graphics.setColor(this.oF.bColors[this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - this.oF.vy) + this.oF.nx * n2]]);
                            graphics.fillRect(n3 * this.oF.scale, n2 * this.oF.scale, this.oF.scale, this.oF.scale);
                        } else {
                            graphics.drawImage(this.tiles[this.oF.map.blocks[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - this.oF.vy) + this.oF.nx * n2]], n3 * this.oF.scale, n2 * this.oF.scale, this.oF.scale, this.oF.scale, this);
                        }
                        this.oF.changed[n3 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - this.oF.vy) + this.oF.nx * n2] = false;
                    }
                }
            }
            graphics.setColor(Color.black);
            if (this.oF.showGrid) {
                for (n3 = 0; n3 < this.oF.nx; ++n3) {
                    graphics.drawRect(n3 * this.oF.scale, 0, this.oF.scale, this.oF.scale * this.oF.nz);
                }
                for (n3 = 0; n3 < this.oF.nz; ++n3) {
                    graphics.drawRect(0, n3 * this.oF.scale, this.oF.scale * this.oF.nx, this.oF.scale);
                }
            }
            graphics.drawRect(0, 0, this.oF.nx * this.oF.scale, this.oF.nz * this.oF.scale);
        } else if (this.oF.currentView == 0) {
            int n6;
            int n7;
            if (this.oF.Overview) {
                n7 = this.oF.alwaysShowAll ? 0 : this.oF.vz;
                graphics.clearRect(0, 0, this.oF.screenSizeX, this.oF.screenSizeY);
                for (n6 = 0; n6 < this.oF.nx; ++n6) {
                    for (int i = 0; i < this.oF.ny; ++i) {
                        int n8 = 0;
                        bl = false;
                        int n9 = n7;
                        while (n9 < this.oF.nz) {
                            n = n6 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - i) + this.oF.nx * n9;
                            n8 = n9++;
                            if (this.oF.map.blocks[n] == 0) continue;
                            bl = true;
                            break;
                        }
                        f = 1.0f - (float)(n8 - n7) * 1.0f / (float)(this.oF.nz - n7);
                        if (this.oF.scale < 16 || this.oF.hideTextures) {
                            try {
                                switch (this.oF.overviewType) {
                                    case 0: {
                                        graphics.setColor(new Color((int)(f * (float)this.oF.bColors[this.oF.map.blocks[n]].getRed()), (int)(f * (float)this.oF.bColors[this.oF.map.blocks[n]].getGreen()), (int)(f * (float)this.oF.bColors[this.oF.map.blocks[n]].getBlue())));
                                        break;
                                    }
                                    case 1: {
                                        graphics.setColor(new Color(f, f, f));
                                        break;
                                    }
                                    case 2: {
                                        graphics.setColor(new Color(Color.HSBtoRGB(f, 1.0f, 1.0f)));
                                    }
                                }
                            }
                            catch (Exception exception) {
                                this.oF.println("Color out of bounds: " + n8 + " " + n7 + " " + f);
                            }
                            if (!bl) continue;
                            graphics.fillRect(n6 * this.oF.scale, i * this.oF.scale, this.oF.scale, this.oF.scale);
                            continue;
                        }
                        try {
                            graphics.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f - 0.5f * f));
                        }
                        catch (Exception exception) {
                            this.oF.println("Color out of bounds: " + n8 + " " + n7 + " " + f);
                        }
                        if (!bl) continue;
                        graphics.drawImage(this.tiles[this.oF.map.blocks[n]], n6 * this.oF.scale, i * this.oF.scale, this.oF.scale, this.oF.scale, this);
                        graphics.fillRect(n6 * this.oF.scale, i * this.oF.scale, this.oF.scale, this.oF.scale);
                    }
                }
            } else if (this.oF.fastDraw) {
                for (n7 = 0; n7 < this.oF.nx; ++n7) {
                    for (n6 = 0; n6 < this.oF.ny; ++n6) {
                        if (!this.oF.changed[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n6) + this.oF.nx * this.oF.vz]) continue;
                        if (this.oF.scale < 16) {
                            graphics.setColor(this.oF.bColors[this.oF.map.blocks[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n6) + this.oF.nx * this.oF.vz]]);
                            graphics.fillRect(n7 * this.oF.scale, n6 * this.oF.scale, this.oF.scale, this.oF.scale);
                        } else {
                            graphics.drawImage(this.tiles[this.oF.map.blocks[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n6) + this.oF.nx * this.oF.vz]], n7 * this.oF.scale, n6 * this.oF.scale, this.oF.scale, this.oF.scale, this);
                        }
                        this.oF.changed[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n6) + this.oF.nx * this.oF.vz] = false;
                    }
                }
            } else {
                graphics.clearRect(0, 0, this.oF.screenSizeX, this.oF.screenSizeY);
                for (n7 = 0; n7 < this.oF.nx; ++n7) {
                    for (n6 = 0; n6 < this.oF.ny; ++n6) {
                        if (this.oF.scale < 16) {
                            graphics.setColor(this.oF.bColors[this.oF.map.blocks[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n6) + this.oF.nx * this.oF.vz]]);
                            graphics.fillRect(n7 * this.oF.scale, n6 * this.oF.scale, this.oF.scale, this.oF.scale);
                        } else {
                            graphics.drawImage(this.tiles[this.oF.map.blocks[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n6) + this.oF.nx * this.oF.vz]], n7 * this.oF.scale, n6 * this.oF.scale, this.oF.scale, this.oF.scale, this);
                        }
                        this.oF.changed[n7 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n6) + this.oF.nx * this.oF.vz] = false;
                    }
                }
            }
            graphics.setColor(Color.black);
            if (this.oF.showGrid) {
                for (n7 = 0; n7 < this.oF.nx; ++n7) {
                    graphics.drawRect(n7 * this.oF.scale, 0, this.oF.scale, this.oF.scale * this.oF.ny);
                }
                for (n7 = 0; n7 < this.oF.ny; ++n7) {
                    graphics.drawRect(0, n7 * this.oF.scale, this.oF.scale * this.oF.nx, this.oF.scale);
                }
            }
            graphics.drawRect(0, 0, this.oF.nx * this.oF.scale, this.oF.ny * this.oF.scale);
        } else if (this.oF.currentView == 2) {
            int n10;
            int n11;
            if (this.oF.Overview) {
                n11 = this.oF.alwaysShowAll ? 0 : this.oF.vx;
                graphics.clearRect(0, 0, this.oF.screenSizeX, this.oF.screenSizeY);
                for (n10 = 0; n10 < this.oF.nz; ++n10) {
                    for (int i = 0; i < this.oF.ny; ++i) {
                        int n12 = 0;
                        bl = false;
                        int n13 = n11;
                        while (n13 < this.oF.nx) {
                            n = n13 + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - i) + this.oF.nx * n10;
                            n12 = n13++;
                            if (this.oF.map.blocks[n] == 0) continue;
                            bl = true;
                            break;
                        }
                        f = 1.0f - (float)(n12 - n11) * 1.0f / (float)(this.oF.nx - n11);
                        if (n12 == this.oF.nx - 1) {
                            f = 1.0f;
                        }
                        if (this.oF.scale < 16 || this.oF.hideTextures) {
                            try {
                                switch (this.oF.overviewType) {
                                    case 0: {
                                        graphics.setColor(new Color((int)(f * (float)this.oF.bColors[this.oF.map.blocks[n]].getRed()), (int)(f * (float)this.oF.bColors[this.oF.map.blocks[n]].getGreen()), (int)(f * (float)this.oF.bColors[this.oF.map.blocks[n]].getBlue())));
                                        break;
                                    }
                                    case 1: {
                                        graphics.setColor(new Color(f, f, f));
                                        break;
                                    }
                                    case 2: {
                                        graphics.setColor(new Color(Color.HSBtoRGB(f, 1.0f, 1.0f)));
                                    }
                                }
                            }
                            catch (Exception exception) {
                                this.oF.println("Color out of bounds: " + n12 + " " + n11 + " " + f);
                            }
                            if (!bl) continue;
                            graphics.fillRect(n10 * this.oF.scale, i * this.oF.scale, this.oF.scale, this.oF.scale);
                            continue;
                        }
                        try {
                            graphics.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f - 0.5f * f));
                        }
                        catch (Exception exception) {
                            this.oF.println("Color out of bounds: " + n12 + " " + n11 + " " + f);
                        }
                        if (!bl) continue;
                        graphics.drawImage(this.tiles[this.oF.map.blocks[n]], n10 * this.oF.scale, i * this.oF.scale, this.oF.scale, this.oF.scale, this);
                        graphics.fillRect(n10 * this.oF.scale, i * this.oF.scale, this.oF.scale, this.oF.scale);
                    }
                }
            } else if (this.oF.fastDraw) {
                for (n11 = 0; n11 < this.oF.ny; ++n11) {
                    for (n10 = 0; n10 < this.oF.nz; ++n10) {
                        if (!this.oF.changed[this.oF.vx + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n11) + this.oF.nx * n10]) continue;
                        if (this.oF.scale < 16) {
                            graphics.setColor(this.oF.bColors[this.oF.map.blocks[this.oF.vx + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n11) + this.oF.nx * n10]]);
                            graphics.fillRect(n10 * this.oF.scale, n11 * this.oF.scale, this.oF.scale, this.oF.scale);
                        } else {
                            graphics.drawImage(this.tiles[this.oF.map.blocks[this.oF.vx + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n11) + this.oF.nx * n10]], n10 * this.oF.scale, n11 * this.oF.scale, this.oF.scale, this.oF.scale, this);
                        }
                        this.oF.changed[this.oF.vx + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n11) + this.oF.nx * n10] = false;
                    }
                }
            } else {
                graphics.clearRect(0, 0, this.oF.screenSizeX, this.oF.screenSizeY);
                for (n11 = 0; n11 < this.oF.ny; ++n11) {
                    for (n10 = 0; n10 < this.oF.nz; ++n10) {
                        if (this.oF.scale < 16) {
                            graphics.setColor(this.oF.bColors[this.oF.map.blocks[this.oF.vx + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n11) + this.oF.nx * n10]]);
                            graphics.fillRect(n10 * this.oF.scale, n11 * this.oF.scale, this.oF.scale, this.oF.scale);
                        } else {
                            graphics.drawImage(this.tiles[this.oF.map.blocks[this.oF.vx + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n11) + this.oF.nx * n10]], n10 * this.oF.scale, n11 * this.oF.scale, this.oF.scale, this.oF.scale, this);
                        }
                        this.oF.changed[this.oF.vx + this.oF.nx * this.oF.nz * (this.oF.ny - 1 - n11) + this.oF.nx * n10] = false;
                    }
                }
            }
            graphics.setColor(Color.black);
            if (this.oF.showGrid) {
                for (n11 = 0; n11 < this.oF.nz; ++n11) {
                    graphics.drawRect(n11 * this.oF.scale, 0, this.oF.scale, this.oF.scale * this.oF.ny);
                }
                for (n11 = 0; n11 < this.oF.ny; ++n11) {
                    graphics.drawRect(0, n11 * this.oF.scale, this.oF.scale * this.oF.nz, this.oF.scale);
                }
            }
            graphics.drawRect(0, 0, this.oF.nz * this.oF.scale, this.oF.ny * this.oF.scale);
        }
        this.oF.fastDraw = false;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.oF.currentView == 1) {
            this.oF.vy = mouseWheelEvent.getWheelRotation() < 0 ? (this.oF.vy == this.oF.ny - 1 ? 0 : ++this.oF.vy) : (this.oF.vy == 0 ? this.oF.ny - 1 : --this.oF.vy);
        } else if (this.oF.currentView == 0) {
            this.oF.vz = mouseWheelEvent.getWheelRotation() < 0 ? (this.oF.vz == this.oF.nz - 1 ? 0 : ++this.oF.vz) : (this.oF.vz == 0 ? this.oF.nz - 1 : --this.oF.vz);
        } else if (this.oF.currentView == 2) {
            this.oF.vx = mouseWheelEvent.getWheelRotation() < 0 ? (this.oF.vx == this.oF.nx - 1 ? 0 : ++this.oF.vx) : (this.oF.vx == 0 ? this.oF.nx - 1 : --this.oF.vx);
        }
        this.oF.fastDraw = false;
        this.oF.updateViewLabel();
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / this.oF.scale;
        int n2 = mouseEvent.getY() / this.oF.scale;
        if (this.oF.tool == 0) {
            if (this.oF.currentView == 1) {
                this.oF.drawXZ(n, n2);
            }
            if (this.oF.currentView == 0) {
                this.oF.drawXY(n, n2);
            }
            if (this.oF.currentView == 2) {
                this.oF.drawZY(n, n2);
            }
            this.oF.fastDraw = true;
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / this.oF.scale;
        int n2 = mouseEvent.getY() / this.oF.scale;
        int n3 = this.oF.nx;
        int n4 = this.oF.nz;
        if (this.oF.currentView == 0) {
            n3 = this.oF.nx;
            n4 = this.oF.ny;
        }
        if (this.oF.currentView == 2) {
            n3 = this.oF.nz;
            n4 = this.oF.ny;
        }
        if (n < n3 && n2 < n4) {
            this.oF.replaceType = this.oF.getBlock(n, n2);
            System.arraycopy(this.oF.map.blocks, 0, this.oF.undoGrid, 0, this.oF.map.blocks.length);
            if (this.oF.tool == 0) {
                if (this.oF.currentView == 1) {
                    this.oF.drawXZ(n, n2);
                }
                if (this.oF.currentView == 0) {
                    this.oF.drawXY(n, n2);
                }
                if (this.oF.currentView == 2) {
                    this.oF.drawZY(n, n2);
                }
                this.oF.fastDraw = true;
                this.repaint();
            } else if (this.oF.tool == 1) {
                this.oF.floodFill2d(n, n2);
                this.oF.fastDraw = true;
                this.repaint();
            } else if (this.oF.tool == 2) {
                this.oF.floodFill3d(n, n2);
                this.repaint();
            } else if (this.oF.tool == 3) {
                this.oF.replaceType2d(n, n2);
                this.oF.fastDraw = true;
                this.repaint();
            } else if (this.oF.tool == 4) {
                this.oF.replaceType3d(n, n2);
                this.oF.fastDraw = true;
                this.repaint();
            } else if (this.oF.tool == 5) {
                this.oF.dropper(n, n2);
            } else if (this.oF.tool == 9) {
                if (this.oF.currentView == 0) {
                    this.oF.randomTree(n, this.oF.ny - 1 - n2, this.oF.vz);
                } else if (this.oF.currentView == 2) {
                    this.oF.randomTree(this.oF.vx, this.oF.ny - 1 - n2, n);
                } else {
                    this.oF.randomTree(n, this.oF.ny - 1 - this.oF.vy, n2);
                }
                this.repaint();
            } else if (this.oF.tool == 10) {
                if (this.oF.currentView == 0) {
                    this.oF.randomRuin(n, this.oF.ny - 1 - n2, this.oF.vz, 3 + (int)(15.0 * Math.random()), 3 + (int)(15.0 * Math.random()), 3 + (int)(15.0 * Math.random()));
                } else if (this.oF.currentView == 2) {
                    this.oF.randomRuin(this.oF.vx, this.oF.ny - 1 - n2, n, 3 + (int)(15.0 * Math.random()), 3 + (int)(15.0 * Math.random()), 3 + (int)(15.0 * Math.random()));
                } else {
                    this.oF.randomRuin(n, this.oF.ny - 1 - this.oF.vy, n2, 3 + (int)(15.0 * Math.random()), 3 + (int)(15.0 * Math.random()), 3 + (int)(15.0 * Math.random()));
                }
                this.repaint();
            } else if (this.oF.tool == 11) {
                if (this.oF.currentView == 0) {
                    this.oF.stairsPrefab(n, this.oF.ny - 1 - n2, this.oF.vz);
                } else if (this.oF.currentView == 2) {
                    this.oF.stairsPrefab(this.oF.vx, this.oF.ny - 1 - n2, n);
                } else {
                    this.oF.stairsPrefab(n, this.oF.ny - 1 - this.oF.vy, n2);
                }
                this.repaint();
            } else if (this.oF.tool == 6) {
                this.oF.setSpawn(n, n2);
                this.oF.updateInfoFields();
            } else if (this.oF.tool == 7) {
                this.oF.drawLine(n, n2);
                this.repaint();
            } else if (this.oF.tool == 8) {
                this.oF.drawBezierLine(n, n2);
                this.repaint();
            }
        }
        this.oF.updateLastBlock(n, n2);
        this.oF.updateViewLabel();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / this.oF.scale;
        int n2 = mouseEvent.getY() / this.oF.scale;
        this.oF.updateLastBlock(n, n2);
        this.oF.updateViewLabel();
    }
}

