/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforums.osici;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import net.minecraftforums.osici.Omen;

class CaveBox
extends JFrame {
    JTextField textField;
    JSlider sizeSlider;
    JSlider blobSlider;
    JComboBox caveTypeBox;
    Omen oF;

    public void makeCaves() {
        int n = 1;
        try {
            n = Integer.parseInt(this.textField.getText());
        }
        catch (Exception exception) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            this.oF.addSingleCave(this.oF.typeNo, this.caveTypeBox.getSelectedIndex(), this.blobSlider.getValue(), (double)this.sizeSlider.getValue() * 0.0015);
        }
    }

    public void makeVeins() {
        int n = 1;
        try {
            n = Integer.parseInt(this.textField.getText());
        }
        catch (Exception exception) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            this.oF.addSingleVein(1, this.caveTypeBox.getSelectedIndex(), 10 * this.blobSlider.getValue(), (double)this.sizeSlider.getValue() * 7.5E-4, 1);
        }
    }

    public CaveBox(Omen omen, boolean bl) {
        this.oF = omen;
        this.setSize(450, 200);
        this.setDefaultCloseOperation(2);
        if (bl) {
            this.setTitle("Add Veins");
        } else {
            this.setTitle("Add Caves");
        }
        String[] stringArray = new String[]{"Cave Type:", "No Caves:", "Cave Density:", "Cave Size:"};
        if (bl) {
            stringArray[0] = "Vein Type:";
            stringArray[1] = "No Veins:";
            stringArray[2] = "Vein Density:";
            stringArray[3] = "Vein Size:";
        }
        JComponent jComponent = (JComponent)this.getContentPane();
        this.caveTypeBox = new JComboBox<String>(omen.labels);
        this.textField = new JTextField("10", 10);
        this.sizeSlider = new JSlider(1, 100, 20);
        this.blobSlider = new JSlider(1, 100, 30);
        jComponent.setLayout(new GridLayout(5, 2));
        JLabel[] jLabelArray = new JLabel[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            jLabelArray[i] = new JLabel(stringArray[i]);
        }
        jComponent.add(jLabelArray[0]);
        jLabelArray[0].setLabelFor(this.caveTypeBox);
        jComponent.add(this.caveTypeBox);
        jComponent.add(jLabelArray[1]);
        jLabelArray[1].setLabelFor(this.textField);
        jComponent.add(this.textField);
        jComponent.add(jLabelArray[2]);
        jLabelArray[2].setLabelFor(this.blobSlider);
        jComponent.add(this.blobSlider);
        jComponent.add(jLabelArray[3]);
        jLabelArray[3].setLabelFor(this.sizeSlider);
        jComponent.add(this.sizeSlider);
        JButton jButton = new JButton("OK");
        if (bl) {
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CaveBox.this.makeVeins();
                    CaveBox.this.dispose();
                }
            });
        } else {
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CaveBox.this.makeCaves();
                    CaveBox.this.dispose();
                }
            });
        }
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CaveBox.this.dispose();
            }
        });
        jComponent.add(jButton);
        jComponent.add(jButton2);
        jComponent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }
}

