/*
 * Decompiled with CFR 0.152.
 */
package daxnitro.nitrous;

import daxnitro.nitrous.BackupManager;
import daxnitro.nitrous.OperatingSystem;
import daxnitro.nitrous.PreferenceManager;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class SettingsPanel
extends JPanel
implements ActionListener {
    private JLabel settingsLabel;
    private JTextField minecraftJarTextField;
    private JButton minecraftJarButton;
    private JButton minecraftJarDefaultButton;
    private JCheckBox backupCheckBox;
    private JButton viewBackupsButton;

    public SettingsPanel() {
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(new Color(0, 0, 0, 0));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        Box box = Box.createHorizontalBox();
        this.settingsLabel = new JLabel("Specify the location of minecraft.jar below.");
        box.add(Box.createHorizontalStrut(5));
        box.add(this.settingsLabel);
        box.setMaximumSize(new Dimension(Integer.MAX_VALUE, box.getPreferredSize().height));
        this.add(box);
        this.add(Box.createVerticalStrut(5));
        box = Box.createHorizontalBox();
        this.minecraftJarTextField = new JTextField(PreferenceManager.getStringValue("MC_JAR_PATH"));
        this.minecraftJarTextField.setColumns(40);
        this.minecraftJarTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                try {
                    PreferenceManager.setStringValue("MC_JAR_PATH", documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                try {
                    PreferenceManager.setStringValue("MC_JAR_PATH", documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                try {
                    PreferenceManager.setStringValue("MC_JAR_PATH", documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.minecraftJarButton = new JButton("Browse");
        this.minecraftJarButton.addActionListener(this);
        this.minecraftJarDefaultButton = new JButton("Default");
        this.minecraftJarDefaultButton.addActionListener(this);
        box.add(this.minecraftJarTextField);
        box.add(this.minecraftJarButton);
        box.add(this.minecraftJarDefaultButton);
        box.setMaximumSize(new Dimension(Integer.MAX_VALUE, box.getPreferredSize().height));
        this.add(box);
        box = Box.createHorizontalBox();
        JSeparator jSeparator = new JSeparator();
        jSeparator.setForeground(Color.GRAY);
        box.add(jSeparator);
        box.setMaximumSize(new Dimension(Integer.MAX_VALUE, box.getPreferredSize().height));
        this.add(box);
        box = Box.createHorizontalBox();
        this.backupCheckBox = new JCheckBox("Create backups.", PreferenceManager.getBoolValue("CREATE_BACKUPS"));
        this.backupCheckBox.setBackground(new Color(0, 0, 0, 0));
        this.backupCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PreferenceManager.setBoolValue("CREATE_BACKUPS", ((AbstractButton)changeEvent.getSource()).isSelected());
            }
        });
        this.viewBackupsButton = new JButton("View Backups");
        this.viewBackupsButton.addActionListener(this);
        box.add(this.backupCheckBox);
        box.add(Box.createHorizontalGlue());
        box.add(this.viewBackupsButton);
        box.setMaximumSize(new Dimension(Integer.MAX_VALUE, box.getPreferredSize().height));
        this.add(box);
        this.add(Box.createVerticalGlue());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.minecraftJarButton) {
            FileDialog fileDialog = new FileDialog((Frame)this.getTopLevelAncestor());
            fileDialog.setDirectory(new File(this.minecraftJarTextField.getText()).getParent());
            fileDialog.setFile(new File(this.minecraftJarTextField.getText()).getName());
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                this.minecraftJarTextField.setText(new File(fileDialog.getDirectory(), fileDialog.getFile()).getAbsolutePath());
            }
        } else if (actionEvent.getSource() == this.minecraftJarDefaultButton) {
            this.minecraftJarTextField.setText(new File(OperatingSystem.getMinecraftSaveDirectory(), "bin/minecraft.jar").getAbsolutePath());
        } else if (actionEvent.getSource() == this.viewBackupsButton) {
            try {
                Desktop.getDesktop().open(BackupManager.backupDirectory());
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this, "No backups have been made yet.");
            }
        }
    }
}

