/*
 * Decompiled with CFR 0.152.
 */
package daxnitro.nitrous;

import daxnitro.nitrous.MouseoverList;
import daxnitro.nitrous.RemoteMod;
import daxnitro.nitrous.RemoteModManager;
import daxnitro.nitrous.RemoteModRepository;
import daxnitro.nitrous.RemoteModsListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;

public class RemoteModsPanel
extends JPanel {
    RemoteModsListModel modsListModel;
    MouseoverList modList;
    RemoteModManager modManager;

    public RemoteModsPanel() {
        MouseoverList mouseoverList;
        RemoteModManager remoteModManager;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(new Color(0, 0, 0, 0));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.modManager = remoteModManager = new RemoteModManager();
        this.modsListModel = new RemoteModsListModel(remoteModManager);
        this.modList = mouseoverList = new MouseoverList((ListModel)this.modsListModel);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseoverList.locationToIndex(mouseEvent.getPoint());
                if (n >= 0 && mouseoverList.getCellBounds(n, n).contains(mouseEvent.getPoint()) && mouseEvent.isPopupTrigger()) {
                    final RemoteMod remoteMod = remoteModManager.mods.get(n);
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    if (!remoteMod.isDownloading) {
                        JMenuItem jMenuItem = new JMenuItem("Download");
                        jMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                RemoteModManager.downloadMod(remoteMod);
                            }
                        });
                        jPopupMenu.add(jMenuItem);
                    } else {
                        JMenuItem jMenuItem = new JMenuItem("Downloading...");
                        jMenuItem.setEnabled(false);
                        jPopupMenu.add(jMenuItem);
                    }
                    jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                }
            }
        };
        mouseoverList.addMouseListener(mouseAdapter);
        mouseoverList.setVisibleRowCount(4);
        mouseoverList.setCellRenderer(new RemoteModsListCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(mouseoverList);
        this.add(jScrollPane);
    }

    public void refreshModList() {
        try {
            this.modManager.catalogMods(new RemoteModRepository("http://nitrous.daxnitro.com/repo/"), 0);
            this.modsListModel.update();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private class RemoteModsListModel
    extends AbstractListModel {
        RemoteModManager modManager;

        public RemoteModsListModel(RemoteModManager remoteModManager) {
            this.modManager = remoteModManager;
        }

        @Override
        public int getSize() {
            return this.modManager.mods.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.modManager.mods.get(n);
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

