/*
 * Decompiled with CFR 0.152.
 */
package daxnitro.nitrous;

import daxnitro.nitrous.RemoteMod;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class RemoteModsListCellRenderer
extends JPanel
implements ListCellRenderer {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MMMMM d, yyyy h:mm a");
    private Color altColor = new Color(237, 243, 255);
    private JLabel nameLabel;
    private JLabel authorLabel;
    private JLabel versionLabel;
    private JLabel mcversionsLabel;
    private JLabel uploadTimeLabel;
    private JLabel descriptionLabel;

    public RemoteModsListCellRenderer() {
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.nameLabel = new JLabel("", 2);
        this.authorLabel = new JLabel("", 2);
        this.versionLabel = new JLabel("", 4);
        this.mcversionsLabel = new JLabel("", 4);
        this.uploadTimeLabel = new JLabel("", 2);
        this.descriptionLabel = new JLabel("", 2);
        Font font = this.nameLabel.getFont();
        this.nameLabel.setFont(font.deriveFont(font.getStyle() ^ 1));
        Box box = Box.createHorizontalBox();
        box.add(this.nameLabel);
        box.add(this.authorLabel);
        box.add(Box.createHorizontalGlue());
        box.add(this.versionLabel);
        this.add(box);
        box = Box.createHorizontalBox();
        box.add(this.uploadTimeLabel);
        box.add(Box.createHorizontalGlue());
        box.add(this.mcversionsLabel);
        this.add(box);
        this.add(new JSeparator());
        box = Box.createHorizontalBox();
        box.add(this.descriptionLabel);
        box.add(Box.createHorizontalGlue());
        this.add(box);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        RemoteMod remoteMod = (RemoteMod)object;
        this.nameLabel.setText(remoteMod.name);
        this.authorLabel.setText(" by " + remoteMod.author);
        this.versionLabel.setText(" " + remoteMod.version);
        if (remoteMod.mcversions.equals("")) {
            this.mcversionsLabel.setText(" ");
        } else {
            this.mcversionsLabel.setText("For " + remoteMod.mcversions);
        }
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.uploadTimeLabel.setText("Uploaded " + this.dateFormat.format(remoteMod.uploadDate));
        this.descriptionLabel.setText(remoteMod.shortDescription + " ");
        if (n % 2 == 0) {
            this.setBackground(this.altColor);
        } else {
            this.setBackground(Color.WHITE);
        }
        return this;
    }
}

