/*
 * Decompiled with CFR 0.152.
 */
package daxnitro.nitrous;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import daxnitro.nitrous.FileUtility;
import daxnitro.nitrous.LocalModManager;
import daxnitro.nitrous.OperatingSystem;
import daxnitro.nitrous.RemoteMod;
import daxnitro.nitrous.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JOptionPane;

public final class RemoteModRepository {
    public URL url;

    public RemoteModRepository(String string) throws MalformedURLException {
        this.url = new URL(string);
    }

    public RemoteModRepository(URL uRL) {
        this.url = uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<RemoteMod> getMods(int n) {
        ArrayList<RemoteMod> arrayList = new ArrayList<RemoteMod>();
        BufferedReader bufferedReader = null;
        try {
            URL uRL = new URL(this.url, "portal/json.php?q=list");
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string = Utility.unhtmlspecialchars(bufferedReader.readLine());
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter((Type)((Object)RemoteMod.class), new RemoteModDeserializer());
            Gson gson = gsonBuilder.create();
            JsonArray jsonArray = (JsonArray)new JsonParser().parse(string);
            Iterator<JsonElement> iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                RemoteMod remoteMod = gson.fromJson(iterator.next(), RemoteMod.class);
                remoteMod.repo = this;
                arrayList.add(remoteMod);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadMod(RemoteMod remoteMod) {
        if (remoteMod.repo != this || remoteMod.isDownloading) {
            return;
        }
        remoteMod.isDownloading = true;
        System.out.println("Downloading " + remoteMod.identifier + "\n");
        File file = null;
        try {
            file = File.createTempFile(remoteMod.identifier, ".zip");
            URL uRL = new URL(this.url, "download.php?mod=" + remoteMod.repoId);
            FileUtility.downloadFile(uRL, file);
            LocalModManager.importMod(file);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            JOptionPane.showMessageDialog(null, malformedURLException, "Download Error", 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(null, iOException, "Download Error", 0);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        new File(OperatingSystem.getSaveDirectory(), "temp").delete();
        remoteMod.isDownloading = false;
    }

    private class RemoteModDeserializer
    implements JsonDeserializer<RemoteMod> {
        private RemoteModDeserializer() {
        }

        @Override
        public RemoteMod deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = (JsonObject)jsonElement;
            RemoteMod remoteMod = new RemoteMod();
            remoteMod.name = jsonObject.getAsJsonPrimitive("name").getAsString();
            remoteMod.author = jsonObject.getAsJsonPrimitive("author").getAsString();
            remoteMod.identifier = jsonObject.getAsJsonPrimitive("identifier").getAsString();
            remoteMod.version = jsonObject.getAsJsonPrimitive("version").getAsString();
            remoteMod.mcversions = jsonObject.getAsJsonPrimitive("mcversions").getAsString();
            remoteMod.shortDescription = jsonObject.getAsJsonPrimitive("short_description").getAsString();
            remoteMod.uploadDate = new Date(jsonObject.getAsJsonPrimitive("upload_time").getAsLong() * 1000L);
            remoteMod.repoId = jsonObject.getAsJsonPrimitive("id").getAsInt();
            return remoteMod;
        }
    }
}

