/*
 * Decompiled with CFR 0.152.
 */
package daxnitro.nitrous;

import daxnitro.nitrous.LocalModManager;
import daxnitro.nitrous.LocalModsPanel;
import daxnitro.nitrous.PreferenceManager;
import daxnitro.nitrous.RemoteModsPanel;
import daxnitro.nitrous.SettingsPanel;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainWindow
extends JFrame {
    private final JTabbedPane tabbedPane;
    private final SettingsPanel settingsPanel;
    private final LocalModsPanel localModsPanel;
    private final RemoteModsPanel remoteModsPanel;

    public MainWindow() {
        super("Nitrous");
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setupMenuBar();
        this.tabbedPane = new JTabbedPane();
        this.localModsPanel = new LocalModsPanel();
        this.remoteModsPanel = new RemoteModsPanel();
        this.settingsPanel = new SettingsPanel();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = MainWindow.this.tabbedPane.getSelectedIndex();
                if (n == 0) {
                    MainWindow.this.localModsPanel.refreshModList();
                } else if (n == 1) {
                    MainWindow.this.remoteModsPanel.refreshModList();
                }
            }
        });
        this.tabbedPane.addTab("Local Mods", this.localModsPanel);
        this.tabbedPane.addTab("Downloadable Mods", this.remoteModsPanel);
        this.tabbedPane.addTab("Options", this.settingsPanel);
        this.add(this.tabbedPane);
        this.pack();
    }

    private void setupMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Import...", 73);
        final MainWindow mainWindow = this;
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileDialog fileDialog = new FileDialog(mainWindow);
                String string = PreferenceManager.getStringValue("LAST_IMPORT");
                if (string != null) {
                    fileDialog.setDirectory(new File(string).getParent());
                    fileDialog.setFile(new File(string).getName());
                }
                fileDialog.setVisible(true);
                if (fileDialog.getFile() != null) {
                    File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
                    PreferenceManager.setStringValue("LAST_IMPORT", file.getAbsolutePath());
                    LocalModManager.importMod(file);
                    MainWindow.this.localModsPanel.updateListModel();
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }
}

