/*
 * Decompiled with CFR 0.152.
 */
package daxnitro.nitrous;

import daxnitro.nitrous.FileUtility;
import daxnitro.nitrous.InstallListener;
import daxnitro.nitrous.LocalMod;
import daxnitro.nitrous.LocalModManager;
import daxnitro.nitrous.LocalModsListCellRenderer;
import daxnitro.nitrous.LogWindow;
import daxnitro.nitrous.MouseoverList;
import daxnitro.nitrous.PreferenceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;

public class LocalModsPanel
extends JPanel
implements ActionListener,
InstallListener {
    private LocalModsListModel modsListModel;
    private JButton viewLogButton;
    private JButton installModsButton;
    private JProgressBar progressBar;
    private LogWindow logWindow = null;

    public LocalModsPanel() {
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(new Color(0, 0, 0, 0));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        LocalModManager.addInstallListener(this);
        Box box = Box.createHorizontalBox();
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        box.add(Box.createHorizontalStrut(1));
        box.add(this.progressBar);
        box.add(Box.createHorizontalGlue());
        this.viewLogButton = new JButton("View Log");
        this.viewLogButton.addActionListener(this);
        box.add(this.viewLogButton);
        this.installModsButton = new JButton("Install Mods");
        this.installModsButton.addActionListener(this);
        box.add(this.installModsButton);
        this.add(box);
        this.modsListModel = new LocalModsListModel();
        final MouseoverList mouseoverList = new MouseoverList((ListModel)this.modsListModel);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseoverList.locationToIndex(mouseEvent.getPoint());
                if (n >= 0 && mouseoverList.getCellBounds(n, n).contains(mouseEvent.getPoint()) && mouseEvent.isPopupTrigger()) {
                    JMenuItem jMenuItem;
                    final LocalMod localMod = LocalModManager.mods.get(n);
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem2 = new JMenuItem("Open Folder");
                    jMenuItem2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                Desktop.getDesktop().open(localMod.directory);
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(mouseoverList, iOException);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(mouseoverList, illegalArgumentException);
                            }
                        }
                    });
                    jPopupMenu.add(jMenuItem2);
                    if (localMod.isEnabled) {
                        jMenuItem = new JMenuItem("Disable");
                        jMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                localMod.isEnabled = false;
                                HashMap<String, Boolean> hashMap = (HashMap<String, Boolean>)PreferenceManager.getObjectValue("DISABLED_MODS");
                                if (hashMap == null) {
                                    hashMap = new HashMap<String, Boolean>();
                                }
                                hashMap.put(localMod.identifier + "-" + localMod.version, Boolean.TRUE);
                                PreferenceManager.setObjectValue("DISABLED_MODS", hashMap);
                                LocalModsPanel.this.refreshModList();
                            }
                        });
                        jPopupMenu.add(jMenuItem);
                    } else {
                        jMenuItem = new JMenuItem("Enable");
                        jMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                localMod.isEnabled = true;
                                HashMap hashMap = (HashMap)PreferenceManager.getObjectValue("DISABLED_MODS");
                                if (hashMap != null) {
                                    hashMap.remove(localMod.identifier + "-" + localMod.version);
                                    PreferenceManager.setObjectValue("DISABLED_MODS", hashMap);
                                }
                                LocalModsPanel.this.refreshModList();
                            }
                        });
                        jPopupMenu.add(jMenuItem);
                    }
                    jMenuItem = new JMenuItem("Delete");
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete " + localMod.name + "?", "Delete Confirmation", 0);
                            if (n == 1) {
                                return;
                            }
                            FileUtility.deleteDirectory(localMod.directory);
                            LocalModsPanel.this.refreshModList();
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                }
            }
        };
        mouseoverList.addMouseListener(mouseAdapter);
        mouseoverList.setVisibleRowCount(4);
        mouseoverList.setCellRenderer(new LocalModsListCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(mouseoverList);
        this.add(jScrollPane);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.installModsButton) {
            if (!LocalModManager.isInstalling) {
                LocalModManager.installMods();
                this.installModsButton.setEnabled(!LocalModManager.isInstalling);
            }
        } else if (actionEvent.getSource() == this.viewLogButton) {
            if (this.logWindow == null) {
                this.logWindow = new LogWindow();
                Point point = ((JFrame)this.getTopLevelAncestor()).getLocation();
                this.logWindow.setLocation(point.x + 200, point.y + 130);
            }
            this.logWindow.setVisible(true);
        }
    }

    @Override
    public void installationStarted() {
        this.progressBar.setString("Initializing");
        this.progressBar.setIndeterminate(true);
    }

    @Override
    public void installationEnded() {
        this.installModsButton.setText("Install Mods");
        this.installModsButton.setEnabled(true);
    }

    @Override
    public void statusChanged(String string) {
        this.progressBar.setString(string);
    }

    @Override
    public void progressChanged(int n) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(n);
    }

    public void refreshModList() {
        LocalModManager.catalogMods();
        this.updateListModel();
    }

    public void updateListModel() {
        this.modsListModel.update();
    }

    private class LocalModsListModel
    extends AbstractListModel {
        private LocalModsListModel() {
        }

        @Override
        public int getSize() {
            return LocalModManager.mods.size();
        }

        @Override
        public Object getElementAt(int n) {
            return LocalModManager.mods.get(n);
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

