/*
 * Decompiled with CFR 0.152.
 */
package daxnitro.nitrous;

import daxnitro.nitrous.FileUtility;
import daxnitro.nitrous.InstallAdapter;
import daxnitro.nitrous.InstallListener;
import daxnitro.nitrous.InstallThread;
import daxnitro.nitrous.LocalMod;
import daxnitro.nitrous.Nitrous;
import daxnitro.nitrous.OperatingSystem;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.zip.ZipException;
import javax.swing.JOptionPane;

public final class LocalModManager {
    public static ArrayList<LocalMod> mods = new ArrayList();
    public static boolean isInstalling = false;
    private static InstallThread installThread = null;
    private static ArrayList<InstallListener> installListeners = new ArrayList();

    protected LocalModManager() {
    }

    public static void catalogMods() {
        System.out.println("Catalogging local mods");
        mods.clear();
        LocalModManager.scanModsInDirectory(new File(OperatingSystem.getSaveDirectory(), "mods"));
        try {
            LocalModManager.scanModsInDirectory(new File(new File(Nitrous.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile(), "mods"));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        System.out.println();
    }

    public static void scanModsInDirectory(File file) {
        System.out.println("Scanning " + file.getPath());
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                LocalMod localMod = new LocalMod(fileArray[i]);
                if (!localMod.isValid) continue;
                System.out.println("Found mod " + localMod.name);
                mods.add(localMod);
            }
        }
    }

    public static void installMods() {
        LocalModManager.installMods(mods);
    }

    public static void installMods(ArrayList<LocalMod> arrayList) {
        if (isInstalling || arrayList.size() == 0) {
            return;
        }
        isInstalling = true;
        installThread = new InstallThread(arrayList);
        installThread.addInstallListener(new InstallAdapter(){

            @Override
            public void installationStarted() {
                LocalModManager.ilInstallationStarted();
            }

            @Override
            public void installationEnded() {
                LocalModManager.ilInstallationEnded();
            }

            @Override
            public void statusChanged(String string) {
                LocalModManager.ilStatusChanged(string);
            }

            @Override
            public void progressChanged(int n) {
                LocalModManager.ilProgressChanged(n);
            }
        });
        installThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void importMod(File file) {
        File file2;
        block13: {
            file2 = new File(OperatingSystem.getSaveDirectory(), "temp/import/");
            File file3 = null;
            try {
                file3 = FileUtility.createTempDirectory("imp" + file.getName(), null, file2);
                FileUtility.unzipFile(file, file3);
                File file4 = FileUtility.findFile(file3, "manifest.xml", 1);
                if (file4 == null) {
                    JOptionPane.showMessageDialog(null, "Couldn't find manifest.xml", "Import Error", 0);
                } else {
                    LocalMod localMod = new LocalMod(file4.getParentFile());
                    if (localMod.isValid) {
                        File file5 = new File(OperatingSystem.getSaveDirectory(), "mods/" + localMod.identifier);
                        if (file5.exists()) {
                            int n = JOptionPane.showConfirmDialog(null, "This will overwrite a previous copy of " + localMod.name + ".  Is this okay?", "Overwrite Confirmation", 0);
                            if (n == 0) {
                                FileUtility.copyDirectoryContents(file4.getParentFile(), file5);
                                System.out.println("Successfully imported mod " + localMod.name);
                                LocalModManager.catalogMods();
                            }
                        } else {
                            FileUtility.copyDirectoryContents(file4.getParentFile(), file5);
                            System.out.println("Successfully imported mod " + localMod.name);
                            mods.add(localMod);
                        }
                    }
                }
                if (file3 == null) break block13;
            }
            catch (ZipException zipException) {
                block14: {
                    zipException.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Invalid file.", "Import Error", 0);
                    if (file3 == null) break block14;
                    FileUtility.deleteDirectory(file3);
                }
                file2.delete();
                file2.getParentFile().delete();
            }
            catch (IOException iOException) {
                block15: {
                    iOException.printStackTrace();
                    JOptionPane.showMessageDialog(null, "The chosen mod could not be imported.", "Import Error", 0);
                    if (file3 == null) break block15;
                    {
                        catch (Throwable throwable) {
                            if (file3 != null) {
                                FileUtility.deleteDirectory(file3);
                            }
                            file2.delete();
                            file2.getParentFile().delete();
                            throw throwable;
                        }
                    }
                    FileUtility.deleteDirectory(file3);
                }
                file2.delete();
                file2.getParentFile().delete();
            }
            FileUtility.deleteDirectory(file3);
        }
        file2.delete();
        file2.getParentFile().delete();
    }

    public static void addInstallListener(InstallListener installListener) {
        installListeners.add(installListener);
    }

    public static void removeInstallListener(InstallListener installListener) {
        installListeners.remove(installListener);
    }

    private static void ilInstallationStarted() {
        int n = installListeners.size();
        for (int i = 0; i < n; ++i) {
            installListeners.get(i).installationStarted();
        }
    }

    private static void ilInstallationEnded() {
        isInstalling = false;
        int n = installListeners.size();
        for (int i = 0; i < n; ++i) {
            installListeners.get(i).installationEnded();
        }
    }

    private static void ilStatusChanged(String string) {
        int n = installListeners.size();
        for (int i = 0; i < n; ++i) {
            installListeners.get(i).statusChanged(string);
        }
    }

    private static void ilProgressChanged(int n) {
        int n2 = installListeners.size();
        for (int i = 0; i < n2; ++i) {
            installListeners.get(i).progressChanged(n);
        }
    }
}

