/*
 * Decompiled with CFR 0.152.
 */
package daxnitro.nitrous;

import daxnitro.nitrous.BackupManager;
import daxnitro.nitrous.FileUtility;
import daxnitro.nitrous.InstallListener;
import daxnitro.nitrous.LocalMod;
import daxnitro.nitrous.ModHooks;
import daxnitro.nitrous.OperatingSystem;
import daxnitro.nitrous.PreferenceManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class InstallThread
extends Thread {
    private int progress = 0;
    private ArrayList<LocalMod> mods;
    private ArrayList<InstallListener> listeners;

    InstallThread(ArrayList<LocalMod> arrayList) {
        this.mods = new ArrayList<LocalMod>(arrayList);
        this.listeners = new ArrayList();
    }

    @Override
    public void run() {
        if (this.mods.size() == 0) {
            return;
        }
        System.out.println("Starting installation");
        this.installationStarted();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setProgress(0);
        this.createBackup();
        if (!this.unpackJAR()) {
            this.installationEnded();
            return;
        }
        this.installMods();
        if (!this.repackJAR()) {
            this.installationEnded();
            return;
        }
        this.progressChanged(100);
        System.out.println("Installation complete\n");
        this.statusChanged("Installation complete");
        this.installationEnded();
    }

    private void setProgress(int n) {
        this.progress = n;
        this.progressChanged(n);
    }

    private void createBackup() {
        if (PreferenceManager.getBoolValue("CREATE_BACKUPS")) {
            System.out.println("Creating backup");
            this.statusChanged("Creating backup");
            BackupManager.createBackup();
            this.setProgress(this.progress + 5);
        }
    }

    private boolean unpackJAR() {
        System.out.println("Unpacking JAR");
        this.statusChanged("Unpacking JAR");
        String string = PreferenceManager.getStringValue("MC_JAR_PATH");
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("Fatal error!\n" + string + " does not exist");
            this.statusChanged("Fatal error");
            return false;
        }
        try {
            FileUtility.unzipFile(file, new File(OperatingSystem.getSaveDirectory(), "temp/minecraft_jar"));
        }
        catch (IOException iOException) {
            System.out.println("Fatal error!");
            iOException.printStackTrace();
            this.statusChanged("Fatal error");
            return false;
        }
        new File(OperatingSystem.getSaveDirectory(), "temp/minecraft_jar/META-INF/MOJANG_C.DSA").delete();
        new File(OperatingSystem.getSaveDirectory(), "temp/minecraft_jar/META-INF/MOJANG_C.SF").delete();
        this.setProgress(this.progress + 5);
        return true;
    }

    private void installMods() {
        int n = this.mods.size();
        int n2 = this.progress;
        float f = (95.0f - (float)this.progress) / (float)n;
        File file = new File(OperatingSystem.getSaveDirectory(), "temp/minecraft_jar");
        int n3 = 0;
        while (n3 < n) {
            LocalMod localMod = this.mods.get(n3);
            if (localMod.isEnabled) {
                System.out.println("\n==== Installing " + localMod.name + " ====");
                this.statusChanged("Installing " + localMod.name);
                boolean bl = false;
                try {
                    ModHooks modHooks = localMod.getHooks();
                    if (modHooks != null) {
                        modHooks.install(file);
                    }
                }
                catch (Throwable throwable) {
                    System.out.println("Error installing " + localMod.name + "!");
                    throwable.printStackTrace();
                    bl = true;
                }
                if (!bl) {
                    try {
                        FileUtility.copyDirectoryContents(new File(localMod.directory, "contents/files"), file);
                    }
                    catch (IOException iOException) {
                        System.out.println("Error installing " + localMod.name + "!");
                        iOException.printStackTrace();
                        bl = true;
                    }
                }
                if (!bl) {
                    System.out.println("==== " + localMod.name + " Successfully Installed ====\n");
                } else {
                    System.out.println("==== " + localMod.name + " Failed Installation ====\n");
                }
            }
            this.setProgress(n2 + (int)Math.ceil((float)(++n3 + 1) * f));
        }
    }

    private boolean repackJAR() {
        System.out.println("Repacking JAR");
        this.statusChanged("Repacking JAR");
        String string = PreferenceManager.getStringValue("MC_JAR_PATH");
        File file = new File(string);
        File file2 = new File(OperatingSystem.getSaveDirectory(), "temp/minecraft_jar");
        try {
            FileUtility.packJar(file, file2);
        }
        catch (IOException iOException) {
            System.out.println("Fatal error!");
            iOException.printStackTrace();
            this.statusChanged("Fatal error");
            return false;
        }
        FileUtility.deleteDirectory(file2);
        new File(OperatingSystem.getSaveDirectory(), "temp").delete();
        this.setProgress(this.progress + 5);
        return true;
    }

    public void addInstallListener(InstallListener installListener) {
        this.listeners.add(installListener);
    }

    private void installationStarted() {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            final InstallListener installListener = this.listeners.get(i);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    installListener.installationStarted();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void installationEnded() {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            final InstallListener installListener = this.listeners.get(i);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    installListener.installationEnded();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void statusChanged(final String string) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            final InstallListener installListener = this.listeners.get(i);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    installListener.statusChanged(string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void progressChanged(final int n) {
        int n2 = this.listeners.size();
        for (int i = 0; i < n2; ++i) {
            final InstallListener installListener = this.listeners.get(i);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    installListener.progressChanged(n);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

