/*
 * Decompiled with CFR 0.152.
 */
package daxnitro.nitrous;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtility {
    protected FileUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packJar(File file, File file2) throws IOException {
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file));
        try {
            FileUtility.addToJar(file2, jarOutputStream, file2);
        }
        finally {
            jarOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(File file, File file2) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            file2.mkdirs();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                Object object;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) {
                    object = new File(file2, zipEntry.getName());
                    ((File)object).mkdirs();
                    continue;
                }
                object = null;
                FileOutputStream fileOutputStream = null;
                try {
                    int n;
                    object = zipFile.getInputStream(zipEntry);
                    File file3 = new File(file2, zipEntry.getName());
                    file3.getParentFile().mkdirs();
                    fileOutputStream = new FileOutputStream(file3);
                    byte[] byArray = new byte[1024];
                    while ((n = ((InputStream)object).read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                    if (fileOutputStream == null) continue;
                    fileOutputStream.close();
                }
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToJar(File file, JarOutputStream jarOutputStream, File file2) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            String string = FileUtility.relativePath(file, file2).replace("\\", "/");
            if (file.isDirectory()) {
                for (File file3 : file.listFiles()) {
                    FileUtility.addToJar(file3, jarOutputStream, file2);
                }
                return;
            }
            JarEntry jarEntry = new JarEntry(string);
            jarEntry.setTime(file.lastModified());
            jarOutputStream.putNextEntry(jarEntry);
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                jarOutputStream.write(byArray, 0, n);
            }
            jarOutputStream.closeEntry();
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    private static String relativePath(File file, File file2) {
        return file2.toURI().relativize(file.toURI()).getPath();
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        file2.createNewFile();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        try {
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (fileChannel2 != null) {
                fileChannel2.close();
            }
        }
    }

    public static void copyDirectoryContents(File file, File file2) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray.length > 0) {
            file2.mkdirs();
        }
        for (int i = fileArray.length - 1; i >= 0; --i) {
            if (fileArray[i].isDirectory()) {
                File file3 = new File(file2, fileArray[i].getName());
                if (file3.exists()) {
                    FileUtility.deleteDirectory(file3);
                }
                file3.mkdir();
                FileUtility.copyDirectoryContents(fileArray[i], file3);
                continue;
            }
            FileUtility.copyFile(fileArray[i], new File(file2, fileArray[i].getName()));
        }
    }

    public static void deleteDirectory(File file) {
        File[] fileArray = file.listFiles();
        for (int i = fileArray.length - 1; i >= 0; --i) {
            if (fileArray[i].isDirectory()) {
                FileUtility.deleteDirectory(fileArray[i]);
                continue;
            }
            fileArray[i].delete();
        }
        file.delete();
    }

    public static void downloadFile(URL uRL, File file) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    public static File findFile(File file, String string, int n) throws IOException {
        File[] fileArray = file.listFiles();
        int n2 = fileArray.length;
        for (int i = 0; i < n2; ++i) {
            if (fileArray[i].isDirectory() && n > 0) {
                File file2 = FileUtility.findFile(fileArray[i], string, n - 1);
                if (file2 == null) continue;
                return file2;
            }
            if (!fileArray[i].getName().equals(string)) continue;
            return fileArray[i];
        }
        return null;
    }

    public static File createTempDirectory(String string, String string2, File file) throws IOException {
        file.mkdirs();
        File file2 = File.createTempFile(string, string2, file);
        if (!file2.delete()) {
            throw new IOException("Could not delete temp file: " + file2.getAbsolutePath());
        }
        if (!file2.mkdir()) {
            throw new IOException("Could not create temp directory: " + file2.getAbsolutePath());
        }
        return file2;
    }
}

